/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.util;

import com.hyperlynx.reactive.ReactiveMod;
import com.hyperlynx.reactive.util.ConfigMan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WorldSpecificValue {
    public static int get(String alias, int min, int max) {
        long seed = (Long)ConfigMan.SERVER.seed.get();
        Random rand = new Random(seed + (long)alias.hashCode());
        return rand.nextInt(max - min + 1) + min;
    }

    public static float get(String alias, float min, float max) {
        long seed = (Long)ConfigMan.SERVER.seed.get();
        Random rand = new Random(seed + (long)alias.hashCode());
        return rand.nextFloat(min, max);
    }

    public static boolean getBool(String alias, float chance) {
        long seed = (Long)ConfigMan.SERVER.seed.get();
        Random rand = new Random(seed + (long)alias.hashCode());
        return rand.nextFloat() < chance;
    }

    public static <T> T getFromCollection(String alias, Collection<T> c) {
        int index = WorldSpecificValue.get(alias, 0, c.size() - 1);
        int p = 0;
        for (T item : c) {
            if (p == index) {
                return item;
            }
            ++p;
        }
        System.err.println("Impossibly tried to pick too high an index @ hyperlynx.reactive.util.WorldSpecificValue");
        return null;
    }

    public static <T> ArrayList<T> shuffle(String alias, List<T> list) {
        ArrayList<T> input = new ArrayList<T>(list);
        ArrayList<T> output = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            int x = WorldSpecificValue.get(alias + i, 0, input.size() - 1);
            output.add(input.get(x));
            input.remove(x);
        }
        return output;
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (event.getWorld().m_5776_()) {
            return;
        }
        long world_seed = event.getWorld().m_142572_().m_129880_(Level.f_46428_).m_7328_();
        if (((Boolean)ConfigMan.SERVER.useWorldSeed.get()).booleanValue()) {
            ConfigMan.SERVER.seed.set((Object)world_seed);
            ConfigMan.SERVER.useWorldSeed.set((Object)false);
        }
        ReactiveMod.REACTION_MAN.reset();
    }
}

