/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.blocks;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.advancements.CriteriaTriggers;
import com.hyperlynx.reactive.advancements.FlagCriterion;
import com.hyperlynx.reactive.be.DisplacedBlockEntity;
import com.hyperlynx.reactive.util.HarvestChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DisplacedBlock
extends Block
implements EntityBlock {
    public DisplacedBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60971_((state, getter, pos) -> false).m_60955_().m_222994_().m_60978_(1.0f).m_155956_(-1.0f).m_60918_(SoundType.f_56728_));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.m_123341_() + rng.m_188501_();
            double y = (float)pos.m_123342_() + rng.m_188501_();
            double z = (float)pos.m_123343_() + rng.m_188501_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void displace(BlockState state_to_be_displaced, BlockPos pos, Level level, int duration) {
        if (!level.f_46443_) {
            FlagCriterion.triggerForNearbyPlayers((ServerLevel)level, CriteriaTriggers.SEE_DISPLACEMENT_TRIGGER, pos, 16);
        }
        DisplacedBlock.displaceWithChain(state_to_be_displaced, pos, level, duration, null);
    }

    public static void displaceWithChain(BlockState state_to_be_displaced, BlockPos pos, Level level, int duration, BlockPos chain) {
        if (level.m_7702_(pos) != null || !HarvestChecker.canMineBlock(level, pos, state_to_be_displaced, 35.0f) || state_to_be_displaced.m_60795_()) {
            return;
        }
        level.m_7731_(pos, ((Block)Registration.DISPLACED_BLOCK.get()).m_49966_(), 2);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof DisplacedBlockEntity)) {
            System.err.println("Displaced Block Entity didn't attach...? Report this to hyperlynx!");
            return;
        }
        DisplacedBlockEntity displaced = (DisplacedBlockEntity)be;
        displaced.self_state = state_to_be_displaced;
        displaced.chain_target = chain;
        level.m_186460_(pos, (Block)Registration.DISPLACED_BLOCK.get(), duration);
    }

    private boolean shouldNotReappear(ServerLevel level, BlockPos pos, DisplacedBlockEntity self_entity) {
        boolean ret = level.m_8055_(pos.m_7495_()).m_60713_((Block)Registration.VOLT_CELL.get());
        if (self_entity.chain_target != null) {
            ret = ret || level.m_8055_(self_entity.chain_target).m_60713_((Block)Registration.DISPLACED_BLOCK.get());
        }
        return ret;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (!(blockentity instanceof DisplacedBlockEntity)) {
            System.err.println("Something went wrong restoring block from displaced block. Report this to hyperlynx! I hope it wasn't expensive...");
            level.m_7731_(pos, Blocks.f_49994_.m_49966_(), 2);
            return;
        }
        if (this.shouldNotReappear(level, pos, (DisplacedBlockEntity)blockentity)) {
            level.m_186460_(pos, (Block)Registration.DISPLACED_BLOCK.get(), 20);
            return;
        }
        level.m_46597_(pos, ((DisplacedBlockEntity)blockentity).self_state);
        level.m_46672_(pos, (Block)this);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DisplacedBlockEntity) {
            DisplacedBlockEntity displaced = (DisplacedBlockEntity)blockEntity;
            if (displaced.self_state.m_60734_() instanceof DisplacedBlock) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 0.6f);
                return true;
            }
            if (level.m_8055_(pos.m_7495_()).m_60713_((Block)Registration.VOLT_CELL.get())) {
                level.m_46961_(pos.m_7495_(), true);
            }
            level.m_46597_(pos, displaced.self_state);
            level.m_5594_(null, pos, SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 0.8f);
        } else {
            System.err.println("Didn't find a valid block entity associated with the displaced block at " + pos + "! Report this to hyperlynx!");
        }
        return true;
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        BlockEntity entity = getter.m_7702_(pos);
        if (!(entity instanceof DisplacedBlockEntity)) {
            return ItemStack.f_41583_;
        }
        DisplacedBlockEntity displaced_entity = (DisplacedBlockEntity)entity;
        if (displaced_entity.self_state.m_60734_() instanceof DisplacedBlock) {
            return ItemStack.f_41583_;
        }
        return displaced_entity.self_state.m_60734_().m_7397_(getter, pos, state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DisplacedBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState p_48758_) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.IGNORE;
    }
}

