/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.blocks;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.blocks.DisplacedBlock;
import com.hyperlynx.reactive.util.HarvestChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MotionSaltBlock
extends Block {
    public static final BooleanProperty POWERED = ObserverBlock.f_55082_;

    public MotionSaltBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_6807_(BlockState p_60566_, Level level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        MotionSaltBlock.causeNeighborToFall(level, pos.m_7495_());
        MotionSaltBlock.causeNeighborToFall(level, pos.m_7918_(1, 0, 0));
        MotionSaltBlock.causeNeighborToFall(level, pos.m_7918_(-1, 0, 0));
        MotionSaltBlock.causeNeighborToFall(level, pos.m_7918_(0, 0, 1));
        MotionSaltBlock.causeNeighborToFall(level, pos.m_7918_(0, 0, -1));
        MotionSaltBlock.checkBecomeElectrified(level, pos, pos.m_7495_());
    }

    public void m_6861_(BlockState our_state, Level level, BlockPos salt_pos, Block block, BlockPos neighbor_pos, boolean unknown) {
        if (level.m_46751_(salt_pos) > 10) {
            level.m_7731_(salt_pos, (BlockState)our_state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (((Boolean)our_state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_7731_(salt_pos, (BlockState)our_state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
        MotionSaltBlock.causeNeighborToFall(level, neighbor_pos);
        MotionSaltBlock.checkBecomeElectrified(level, salt_pos, neighbor_pos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        DisplacedBlock.displace(state, pos, (Level)level, 200);
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            DisplacedBlock.displaceWithChain(level.m_8055_(pos.m_7494_()), pos.m_7494_(), (Level)level, 210, pos);
        }
    }

    private static void causeNeighborToFall(Level level, BlockPos neighbor_pos) {
        if (!level.m_8055_(neighbor_pos.m_7495_()).m_60795_()) {
            return;
        }
        if (HarvestChecker.canMineBlock(level, neighbor_pos, level.m_8055_(neighbor_pos), 35.0f)) {
            FallingBlockEntity.m_201971_((Level)level, (BlockPos)neighbor_pos, (BlockState)level.m_8055_(neighbor_pos));
        }
    }

    private static void checkBecomeElectrified(Level level, BlockPos salt_pos, BlockPos neighbor_pos) {
        if (level.m_8055_(neighbor_pos).m_60713_((Block)Registration.VOLT_CELL.get()) && salt_pos.m_7495_().equals((Object)neighbor_pos)) {
            level.m_186460_(salt_pos, (Block)Registration.MOTION_SALT_BLOCK.get(), 10);
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 100;
    }
}

