/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.items;

import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.blocks.CrucibleBlock;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LitmusPaperItem
extends Item {
    public static final String TAG_MEASUREMENT = "Measurement";

    public LitmusPaperItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> hover_text, TooltipFlag tooltip_flag) {
        super.m_7373_(stack, level, hover_text, tooltip_flag);
        if (!stack.m_41782_()) {
            return;
        }
        ListTag measurements = stack.m_41783_().m_128437_(TAG_MEASUREMENT, 10);
        for (Tag tag : measurements) {
            hover_text.add((Component)Component.m_237113_((String)((CompoundTag)tag).m_128461_("value")));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_() && level.f_46443_) {
            if (!player.m_21120_(hand).m_41782_()) {
                return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
            }
            ListTag measurements = player.m_21120_(hand).m_41783_().m_128437_(TAG_MEASUREMENT, 10);
            for (Tag tag : measurements) {
                player.m_213846_((Component)Component.m_237113_((String)((CompoundTag)tag).m_128461_("value")));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!(context.m_43725_().m_8055_(context.m_8083_()).m_60734_() instanceof CrucibleBlock)) {
            return InteractionResult.PASS;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)context.m_43725_().m_7702_(context.m_8083_());
        if (crucible == null || crucible.getTotalPowerLevel() == 0) {
            return InteractionResult.PASS;
        }
        LitmusPaperItem.takeMeasurement(context.m_43722_(), crucible);
        return InteractionResult.SUCCESS;
    }

    public static void takeMeasurement(ItemStack paper, CrucibleBlockEntity crucible) {
        ListTag measurements = new ListTag();
        for (Power p : crucible.getPowerMap().keySet()) {
            if (crucible.getPowerLevel(p) == 0) continue;
            String measurement = p.getName().toUpperCase() + " - ";
            measurement = crucible.getPowerLevel(p) < 500 ? measurement + "LOW" : (500 <= crucible.getPowerLevel(p) && crucible.getPowerLevel(p) < 1000 ? measurement + "MEDIUM" : measurement + "HIGH");
            CompoundTag mt = new CompoundTag();
            mt.m_128359_("value", measurement);
            measurements.add((Object)mt);
        }
        if (!paper.m_41782_()) {
            paper.m_41751_(new CompoundTag());
        }
        paper.m_41783_().m_128365_(TAG_MEASUREMENT, (Tag)measurements);
    }
}

