/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.items;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.SpecialCaseMan;
import com.hyperlynx.reactive.items.CrystalIronItem;
import com.hyperlynx.reactive.items.PowerBottleItem;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WarpBottleItem
extends PowerBottleItem {
    public static final String TAG_TELEPORT_DESTINATION = "TeleportPos";
    public static final String TAG_TELEPORT_DIMENSION = "TeleportDimension";

    public WarpBottleItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public Component m_41466_() {
        return super.m_41466_();
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return WarpBottleItem.isRiftBottle(stack) || super.m_5812_(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        if (WarpBottleItem.isRiftBottle(player.m_21120_(hand))) {
            GlobalPos destination;
            CompoundTag tag = player.m_21120_(hand).m_41783_();
            boolean warp_occurred = false;
            if (tag != null && level.m_46472_().equals(WarpBottleItem.getTeleportDimension(tag).orElse(null)) && (destination = WarpBottleItem.getTeleportPosition(tag)) != null) {
                if (CrystalIronItem.effectNotBlocked((LivingEntity)player, 1)) {
                    player.m_6021_((double)destination.m_122646_().m_123341_() + 0.5, (double)destination.m_122646_().m_123342_() + 0.85, (double)destination.m_122646_().m_123343_() + 0.5);
                    warp_occurred = true;
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.reactive.warp_blocked"), true);
                    warp_occurred = SpecialCaseMan.tryTeleportNearbyEntity(player.m_20097_(), level, destination.m_122646_(), false);
                }
            }
            if (warp_occurred && !player.m_7500_()) {
                player.m_21008_(hand, ((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
            }
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(level, player, hand);
    }

    public int getMaxStackSize(ItemStack stack) {
        if (WarpBottleItem.isRiftBottle(stack)) {
            return 1;
        }
        return super.getMaxStackSize(stack);
    }

    public static void addTeleportTags(ResourceKey<Level> lkey, BlockPos pos, CompoundTag tag) {
        tag.m_128365_(TAG_TELEPORT_DESTINATION, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, lkey).result().ifPresent(dim_key -> tag.m_128365_(TAG_TELEPORT_DIMENSION, dim_key));
    }

    public static boolean isRiftBottle(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_(TAG_TELEPORT_DESTINATION);
    }

    private static Optional<ResourceKey<Level>> getTeleportDimension(CompoundTag p_40728_) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_40728_.m_128423_(TAG_TELEPORT_DIMENSION)).result();
    }

    public static GlobalPos getTeleportPosition(CompoundTag p_220022_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_220022_.m_128441_(TAG_TELEPORT_DESTINATION);
        boolean flag1 = p_220022_.m_128441_(TAG_TELEPORT_DIMENSION);
        if (flag && flag1 && (optional = WarpBottleItem.getTeleportDimension(p_220022_)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)p_220022_.m_128469_(TAG_TELEPORT_DESTINATION));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }
}

