/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.PowerBearer;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PrecipitateRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final ItemStack product;
    protected final List<Power> reagents;
    int cost;
    int minimum;
    int reagent_count;
    public boolean needs_electricity;

    public PrecipitateRecipe(ResourceLocation id, String group, ItemStack product, List<Power> reagents, int min, int cost, int reagent_count, boolean needs_electricity) {
        this.id = id;
        this.group = group;
        this.product = product;
        this.reagents = reagents;
        this.minimum = min;
        this.cost = cost;
        this.reagent_count = reagent_count;
        this.needs_electricity = needs_electricity;
    }

    public boolean powerMet(PowerBearer bearer, Level level) {
        ArrayList<Power> sorted_reagents = WorldSpecificValue.shuffle(this.id + "_reagent_order", this.reagents);
        int power_level = 0;
        int iterations = 0;
        boolean has_all_reagents = true;
        for (Power p : sorted_reagents) {
            if (iterations > this.reagent_count) break;
            if (bearer.getPowerLevel(p) == 0) {
                has_all_reagents = false;
                break;
            }
            power_level += bearer.getPowerLevel(p);
            ++iterations;
        }
        return has_all_reagents && power_level > this.minimum;
    }

    public ItemStack apply(PowerBearer bearer, Level level) {
        if (this.cost > 0) {
            for (Power p : this.reagents) {
                bearer.expendPower(p, this.cost / this.reagent_count);
            }
        }
        ItemStack result = this.product.m_41777_();
        result.m_41764_(result.m_41613_());
        return result;
    }

    public boolean m_5818_(Container container, @NotNull Level level) {
        return true;
    }

    public ItemStack m_5874_(Container container) {
        return this.product.m_41777_();
    }

    public ItemStack m_8043_() {
        return this.product;
    }

    public List<Power> getReagents() {
        return this.reagents;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.PRECIPITATE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registration.PRECIPITATE_RECIPE_TYPE.get();
    }

    public String toString() {
        return this.id.toString();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }
}

