/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.PowerBearer;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TransmuteRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient reactant;
    protected final ItemStack product;
    protected final List<Power> reagents;
    int cost;
    int minimum;
    public boolean needs_electricity;

    public TransmuteRecipe(ResourceLocation id, String group, Ingredient reactant, ItemStack product, List<Power> reagents, int min, int cost, boolean needs_electricity) {
        this.id = id;
        this.group = group;
        this.reactant = reactant;
        this.product = product;
        this.reagents = reagents;
        this.minimum = min;
        this.cost = cost;
        this.needs_electricity = needs_electricity;
    }

    public boolean powerMet(PowerBearer bearer) {
        int power_level = 0;
        boolean has_all_reagents = true;
        for (Power p : this.reagents) {
            if (bearer.getPowerLevel(p) == 0) {
                has_all_reagents = false;
                break;
            }
            power_level += bearer.getPowerLevel(p);
        }
        return has_all_reagents && power_level > this.minimum;
    }

    public ItemStack apply(ItemStack input, PowerBearer bearer) {
        int max_tfs = Integer.MAX_VALUE;
        if (this.cost > 0) {
            for (Power p : this.reagents) {
                max_tfs = Math.min(max_tfs, bearer.getPowerLevel(p) / (this.cost / this.reagents.size()));
                bearer.expendPower(p, this.cost / this.reagents.size() * input.m_41613_());
            }
        }
        ItemStack result = this.product.m_41777_();
        result.m_41764_(Math.min(input.m_41613_(), max_tfs) * result.m_41613_());
        input.m_41764_(input.m_41613_() - Math.min(input.m_41613_(), max_tfs));
        return result;
    }

    public boolean m_5818_(Container container, @NotNull Level level) {
        for (ItemStack i : this.reactant.m_43908_()) {
            if (!container.m_8020_(0).m_150930_(i.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_5874_(Container container) {
        return this.product.m_41777_();
    }

    public ItemStack m_8043_() {
        return this.product;
    }

    public Ingredient getReactant() {
        return this.reactant;
    }

    public List<Power> getReagents() {
        return this.reagents;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.TRANS_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registration.TRANS_RECIPE_TYPE.get();
    }

    public String toString() {
        return this.id.toString();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }
}

