/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmuteRecipeSerializer
implements RecipeSerializer<TransmuteRecipe> {
    @NotNull
    public TransmuteRecipe fromJson(@NotNull ResourceLocation id, JsonObject json) {
        try {
            Ingredient reactant = CraftingHelper.getIngredient((JsonElement)json.get("reactant").getAsJsonObject());
            ItemStack product = CraftingHelper.getItemStack((JsonObject)json.get("product").getAsJsonObject(), (boolean)false);
            ArrayList<Power> reagents = new ArrayList<Power>();
            for (JsonElement j : json.get("reagents").getAsJsonArray()) {
                RegistryObject powObj = RegistryObject.create((ResourceLocation)ResourceLocation.m_135820_((String)j.getAsString()), Powers.POWER_SUPPLIER.get());
                if (powObj.isPresent()) {
                    reagents.add((Power)powObj.get());
                    continue;
                }
                System.err.println("Tried to read a fake power " + j.getAsString() + " in recipe " + id);
            }
            int min = json.get("min").getAsInt();
            int cost = json.get("cost").getAsInt();
            boolean needs_electricity = false;
            if (json.has("needs_electricity")) {
                needs_electricity = json.get("needs_electricity").getAsBoolean();
            }
            return new TransmuteRecipe(id, "transmutation", reactant, product, reagents, min, cost, needs_electricity);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public TransmuteRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
        Ingredient reactant = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack product = buffer.m_130267_();
        List reagents = (List)buffer.m_236838_(ArrayList::new, IForgeFriendlyByteBuf::readRegistryId);
        int min = buffer.m_130242_();
        int cost = buffer.m_130242_();
        boolean needs_electricity = buffer.readBoolean();
        return new TransmuteRecipe(id, "transmutation", reactant, product, reagents, min, cost, needs_electricity);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull TransmuteRecipe recipe) {
        recipe.reactant.m_43923_(buffer);
        buffer.m_130055_(recipe.product);
        buffer.m_236828_(recipe.reagents, (b, p) -> b.writeRegistryId(Powers.POWER_SUPPLIER.get(), p));
        buffer.m_130130_(recipe.minimum);
        buffer.m_130130_(recipe.cost);
        buffer.writeBoolean(recipe.needs_electricity);
    }
}

