/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes.docs;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class TransmuteComponentProcessor
implements IComponentProcessor {
    private TransmuteRecipe recipe;

    public void setup(IVariableProvider variables) {
        String recipeId = "reactive:transmutation/" + variables.get("recipe").asString();
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        List recipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)Registration.TRANS_RECIPE_TYPE.get());
        for (TransmuteRecipe r : recipes) {
            if (!r.m_6423_().equals((Object)new ResourceLocation(recipeId))) continue;
            this.recipe = r;
            break;
        }
        if (this.recipe == null) {
            throw new IllegalArgumentException();
        }
    }

    public IVariable process(@NotNull String key) {
        if (key.equals("reactant")) {
            return IVariable.from((Object)this.recipe.getReactant().m_43908_());
        }
        if (key.equals("product")) {
            return IVariable.from((Object)this.recipe.m_8043_());
        }
        if (key.equals("reagents")) {
            ArrayList<String> reagent_list = new ArrayList<String>();
            for (Power reagent : this.recipe.getReagents()) {
                reagent_list.add(reagent.getName());
            }
            return IVariable.wrap((String)("$(4)Reagents: " + ((Object)reagent_list).toString().substring(1, ((Object)reagent_list).toString().length() - 1)));
        }
        return null;
    }
}

