/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes.jei;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.items.StaffItem;
import com.hyperlynx.reactive.recipes.jei.DissolveRecipeCategory;
import com.hyperlynx.reactive.recipes.jei.PowerIngredientHandler;
import com.hyperlynx.reactive.recipes.jei.PowerIngredientRenderer;
import com.hyperlynx.reactive.recipes.jei.PowerIngredientType;
import com.hyperlynx.reactive.recipes.jei.TransmuteRecipeCategory;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ReactiveJEIPlugin
implements IModPlugin {
    public static IJeiHelpers HELPERS;
    public static DissolveRecipeCategory DISSOLVE_CATEGORY;
    public static TransmuteRecipeCategory TRANSMUTE_CATEGORY;
    public static PowerIngredientType POWER_TYPE;
    public static PowerIngredientHandler POWER_HANDLER;
    public static PowerIngredientRenderer POWER_RENDERER;

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("reactive", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{DISSOLVE_CATEGORY});
        registration.addRecipeCategories(new IRecipeCategory[]{TRANSMUTE_CATEGORY});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register((IIngredientType)POWER_TYPE, Powers.POWER_SUPPLIER.get().getValues(), (IIngredientHelper)POWER_HANDLER, (IIngredientRenderer)POWER_RENDERER);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        HELPERS = registration.getJeiHelpers();
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(DISSOLVE_CATEGORY.getRecipeType(), level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.DISSOLVE_RECIPE_TYPE.get()));
        registration.addRecipes(TRANSMUTE_CATEGORY.getRecipeType(), level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.TRANS_RECIPE_TYPE.get()));
        this.addDescriptions(registration);
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_BLAZE_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_LIFE_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_LIGHT_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_MIND_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_WARP_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_SOUL_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)POWER_TYPE, Powers.POWER_SUPPLIER.get().getValues());
    }

    private void addDescriptions(IRecipeRegistration registration) {
        registration.addItemStackInfo(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.crucible")});
        registration.addItemStackInfo(((Item)Registration.SALT.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.GOLD_FOAM_ITEM.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.MOTION_SALT.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.SECRET_SCALE.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        this.addGenericDescriptions(registration, (Item)Registration.STAFF_OF_WARP_ITEM.get(), (Item)Registration.STAFF_OF_MIND_ITEM.get(), (Item)Registration.STAFF_OF_BLAZE_ITEM.get(), (Item)Registration.STAFF_OF_LIFE_ITEM.get(), (Item)Registration.STAFF_OF_LIGHT_ITEM.get(), (Item)Registration.STAFF_OF_SOUL_ITEM.get(), (Item)Registration.SOLID_PORTAL_ITEM.get(), (Item)Registration.LIGHT_BOTTLE.get(), (Item)Registration.MIND_BOTTLE.get(), (Item)Registration.BODY_BOTTLE.get(), (Item)Registration.WARP_BOTTLE.get(), (Item)Registration.BLAZE_BOTTLE.get(), (Item)Registration.ACID_BOTTLE.get(), (Item)Registration.VERDANT_BOTTLE.get(), (Item)Registration.SOUL_BOTTLE.get());
        this.addPowerDescriptions(registration);
    }

    private void addGenericDescriptions(IRecipeRegistration registration, Item ... items) {
        for (Item item : items) {
            registration.addItemStackInfo(item.m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.generic")});
        }
    }

    private void addPowerDescriptions(IRecipeRegistration registration) {
        for (Power power : Powers.POWER_SUPPLIER.get().getValues()) {
            registration.addIngredientInfo((Object)power, (IIngredientType)POWER_TYPE, new Component[]{Component.m_237115_((String)"jei.reactive.power")});
        }
    }

    private void addStaffRepairRecipe(StaffItem staff, IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ItemStack full_durability = new ItemStack((ItemLike)staff);
        ItemStack three_quarters_durability = new ItemStack((ItemLike)staff);
        three_quarters_durability.m_41721_(full_durability.m_41776_() / 4);
        ItemStack half_durability = new ItemStack((ItemLike)staff);
        half_durability.m_41721_(full_durability.m_41776_() / 2);
        IJeiAnvilRecipe sacrifice_repair_recipe = factory.createAnvilRecipe(half_durability, List.of(half_durability), List.of(full_durability));
        IJeiAnvilRecipe bottle_repair_recipe = factory.createAnvilRecipe(three_quarters_durability, List.of(new ItemStack((ItemLike)staff.repair_item)), List.of(full_durability));
        registration.addRecipes(RecipeTypes.ANVIL, List.of(sacrifice_repair_recipe, bottle_repair_recipe));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new RecipeType[]{DISSOLVE_CATEGORY.getRecipeType()});
        registration.addRecipeCatalyst(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new RecipeType[]{TRANSMUTE_CATEGORY.getRecipeType()});
    }

    static {
        DISSOLVE_CATEGORY = new DissolveRecipeCategory();
        TRANSMUTE_CATEGORY = new TransmuteRecipeCategory();
        POWER_TYPE = new PowerIngredientType();
        POWER_HANDLER = new PowerIngredientHandler();
        POWER_RENDERER = new PowerIngredientRenderer();
    }
}

