/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block.BlockInfestation;

import com.github.sculkhorde.common.block.InfestedLogBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class InfestationConversionHandler {
    public ArrayList<BlockPos> convertToVictimNodeQueue = new ArrayList();
    public ArrayList<BlockPos> convertToInfectedNodeQueue = new ArrayList();
    public final int conversionAmountPerInterval = 1;
    public ArrayList<ConversionRequest> conversionQueue = new ArrayList();
    public InfestationTable infestationTable = new InfestationTable();

    public boolean infectBlock(ServerWorld world, BlockPos targetPos) {
        BlockState targetBlock = world.func_180495_p(targetPos);
        BlockState newBlock = null;
        newBlock = this.infestationTable.getInfestedVariant(targetBlock);
        if (targetBlock.func_235714_a_((ITag)BlockTags.field_200031_h)) {
            newBlock = ((InfestedLogBlock)BlockRegistry.INFESTED_LOG_DORMANT.get()).func_176223_P();
        }
        if (newBlock == null) {
            return false;
        }
        world.func_175656_a(targetPos, newBlock);
        ArrayList<BlockPos> adjacentBlockPos = BlockAlgorithms.getAdjacentNeighbors(targetPos);
        for (BlockPos pos : adjacentBlockPos) {
            BlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() != BlockRegistry.VEIN.get() || blockState.func_177230_c().func_196260_a(blockState, (IWorldReader)world, pos)) continue;
            world.func_175655_b(pos, false);
        }
        if (world.field_73012_v.nextInt(4) <= 0) {
            BlockAlgorithms.placeSculkFlora(targetPos.func_177984_a(), world);
        }
        if (newBlock.func_177230_c() == BlockRegistry.INFESTED_LOG_DORMANT.get()) {
            BlockAlgorithms.placeFloraAroundLog(world, targetPos);
        }
        SculkHorde.gravemind.placeSculkNode(world, targetPos.func_177984_a(), true);
        BlockAlgorithms.placePatchesOfVeinAbove(world, targetPos);
        BlockAlgorithms.placeSculkBeeHive(world, targetPos.func_177984_a());
        return true;
    }

    public boolean deinfectBlock(ServerWorld world, BlockPos targetPos) {
        BlockState targetBlock = world.func_180495_p(targetPos);
        BlockState victimVariant = this.infestationTable.getNormalVariant(targetBlock);
        if (targetBlock.func_203425_a((Block)BlockRegistry.INFESTED_LOG_DORMANT.get())) {
            victimVariant = Blocks.field_150350_a.func_176223_P();
        }
        if (victimVariant != null) {
            world.func_175656_a(targetPos, victimVariant);
            return true;
        }
        return false;
    }

    public void processDeInfectionQueue(ServerWorld world) {
        if (!world.func_201670_d()) {
            for (int i = 0; i < 1 && i < this.convertToVictimNodeQueue.size(); ++i) {
                BlockAlgorithms.replaceSculkFlora(world, this.convertToVictimNodeQueue.get(i));
                this.deinfectBlock(world, this.convertToVictimNodeQueue.get(i));
                this.convertToVictimNodeQueue.remove(i);
                --i;
            }
        }
    }

    public class InfestationTableEntry {
        private BlockState normalVariant;
        private BlockState infectedVariant;

        public InfestationTableEntry(BlockState normalVariantIn, BlockState infectedVariantIn) {
            this.normalVariant = normalVariantIn;
            this.infectedVariant = infectedVariantIn;
        }

        public BlockState getNormalVariant() {
            return this.normalVariant;
        }

        public BlockState getInfectedVariant() {
            return this.infectedVariant;
        }
    }

    public class InfestationTable {
        private List<InfestationTableEntry> entries = new ArrayList<InfestationTableEntry>();

        public void addEntry(BlockState normalVariant, BlockState infectedVariant) {
            this.entries.add(new InfestationTableEntry(normalVariant, infectedVariant));
        }

        public BlockState getInfestedVariant(BlockState normalVariant) {
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getNormalVariant() != normalVariant) continue;
                return entry.getInfectedVariant();
            }
            return null;
        }

        public BlockState getNormalVariant(BlockState infectedVariant) {
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getInfectedVariant() != infectedVariant) continue;
                return entry.getNormalVariant();
            }
            return null;
        }

        public boolean isNormalVariant(BlockState blockState) {
            if (blockState.func_235714_a_((ITag)BlockTags.field_200031_h)) {
                return true;
            }
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getNormalVariant() != blockState) continue;
                return true;
            }
            return false;
        }

        public boolean isInfectedVariant(BlockState blockState) {
            if (blockState.func_203425_a((Block)BlockRegistry.INFESTED_LOG_DORMANT.get())) {
                return true;
            }
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getInfectedVariant() != blockState) continue;
                return true;
            }
            return false;
        }
    }

    public class ConversionRequest {
        private BlockPos position;
        private boolean convertToInfested;
        private boolean convertToNormal;

        public ConversionRequest(BlockPos positionIn) {
            this.position = positionIn;
        }

        public BlockPos getPosition() {
            return this.position;
        }
    }
}

