/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;

public class CocoonBlock
extends SculkFloraBlock
implements IForgeBlock {
    boolean DEBUG_THIS;
    public static Material MATERIAL = Material.field_151572_C;
    public static MaterialColor MAP_COLOR = MaterialColor.field_193572_X;
    public static float HARDNESS = 0.6f;
    public static float BLAST_RESISTANCE = 0.5f;
    public static ToolType PREFERRED_TOOL = ToolType.SHOVEL;
    public static int HARVEST_LEVEL = -1;
    private final int ACTIVATION_DISTANCE = 32;
    private List<LivingEntity> possibleLivingEntityTargets;
    private List<LivingEntity> possibleAggressorTargets;

    public CocoonBlock(AbstractBlock.Properties prop) {
        super(prop);
        if (SculkHorde.DEBUG_MODE) {
            // empty if block
        }
        this.DEBUG_THIS = false;
        this.ACTIVATION_DISTANCE = 32;
    }

    public CocoonBlock() {
        this(CocoonBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        AbstractBlock.Properties prop = AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_226896_b_().func_200947_a(SoundType.field_185859_l);
        return prop;
    }

    @Override
    public boolean func_200123_i(BlockState blockState, IBlockReader blockReader, BlockPos blockPos) {
        return true;
    }

    public boolean canCreatureSpawn(BlockState state2, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    @Override
    public boolean func_200014_a_(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        BlockPos[] cocoonPosNeighbors;
        Block[] validBlocks;
        boolean blockIsValid = false;
        boolean cocoonPosCanBeReplacedByWater = false;
        boolean cocoonPosHasNoNeighbors = true;
        BlockPos cocoonPos = blockPos.func_177984_a();
        cocoonPosCanBeReplacedByWater = iBlockReader.func_180495_p(cocoonPos).func_227032_a_((Fluid)Fluids.field_204546_a);
        for (Block b : validBlocks = new Block[]{(Block)BlockRegistry.COCOON_ROOT.get()}) {
            if (blockState.func_177230_c() != b) continue;
            blockIsValid = true;
        }
        for (BlockPos bp : cocoonPosNeighbors = new BlockPos[]{cocoonPos.func_177978_c(), cocoonPos.func_177974_f(), cocoonPos.func_177968_d(), cocoonPos.func_177976_e(), cocoonPos.func_177984_a()}) {
            if (iBlockReader.func_180495_p(bp).func_196958_f()) continue;
            cocoonPosHasNoNeighbors = false;
        }
        if (this.DEBUG_THIS) {
            System.out.println("\nAttempted to Place " + ((Object)((Object)this)).getClass().toString() + " at " + blockPos.toString() + "\nblockIsValid " + blockIsValid + "\ncocoonPosHasNoNeighbors " + cocoonPosHasNoNeighbors);
        }
        return blockIsValid && cocoonPosCanBeReplacedByWater && cocoonPosHasNoNeighbors;
    }

    public void onNeighborChange(BlockState state2, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        this.func_176206_d((IWorld)world, pos, this.func_176223_P());
    }

    public boolean func_149653_t(BlockState blockState) {
        return true;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos bp, Random random) {
        AxisAlignedBB searchArea = EntityAlgorithms.getSearchAreaRectangle(bp.func_177958_n(), bp.func_177956_o(), bp.func_177952_p(), 32.0, 5.0, 32.0);
        this.possibleAggressorTargets = EntityAlgorithms.getLivingEntitiesInBoundingBox(serverWorld, searchArea);
        this.possibleLivingEntityTargets = EntityAlgorithms.getLivingEntitiesInBoundingBox(serverWorld, searchArea);
        ReinforcementRequest context = new ReinforcementRequest(bp);
        context.sender = ReinforcementRequest.senderType.SculkCocoon;
        if (!this.possibleAggressorTargets.isEmpty()) {
            context.is_aggressor_nearby = true;
        }
        if (!this.possibleLivingEntityTargets.isEmpty()) {
            context.is_non_sculk_mob_nearby = true;
        }
        if (context.is_non_sculk_mob_nearby || context.is_aggressor_nearby) {
            if (this.DEBUG_THIS) {
                System.out.println("Sending out Reinforcement Request");
            }
            SculkHorde.entityFactory.requestReinforcementAny((World)serverWorld, bp, false, context);
            if (context.isRequestViewed && context.isRequestApproved) {
                serverWorld.func_175655_b(bp, false);
            }
        }
    }
}

