/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.block.CocoonBlock;
import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;

public class CocoonRootBlock
extends SculkFloraBlock
implements IForgeBlock {
    public static Material MATERIAL = Material.field_151585_k;
    public static MaterialColor MAP_COLOR = MaterialColor.field_193572_X;
    public static float HARDNESS = 0.6f;
    public static float BLAST_RESISTANCE = 0.5f;
    public static ToolType PREFERRED_TOOL = ToolType.HOE;
    public static int HARVEST_LEVEL = 3;

    public CocoonRootBlock(AbstractBlock.Properties prop) {
        super(prop);
    }

    public CocoonRootBlock() {
        this(CocoonRootBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        AbstractBlock.Properties prop = AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_185851_d).func_226896_b_();
        return prop;
    }

    public boolean func_149653_t(BlockState blockState) {
        return true;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos bp, Random random) {
        this.grow(serverWorld, bp);
    }

    public boolean grow(ServerWorld serverWorld, BlockPos bp) {
        if (this.getGrowthStage(serverWorld, bp) == growthStage.immature) {
            ((CocoonBlock)BlockRegistry.COCOON.get()).placeBlockHere(serverWorld, bp.func_177984_a());
            return true;
        }
        return false;
    }

    private growthStage getGrowthStage(ServerWorld serverWorld, BlockPos bp) {
        Block aboveBlock = serverWorld.func_180495_p(bp.func_177984_a()).func_177230_c();
        if (aboveBlock.func_235332_a_((Block)BlockRegistry.COCOON.get())) {
            return growthStage.mature;
        }
        return growthStage.immature;
    }

    public boolean canCreatureSpawn(BlockState state2, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    @Override
    public boolean func_200014_a_(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        Block[] validBlocks;
        boolean DEBUG_THIS = false;
        boolean blockIsValid = false;
        for (Block b : validBlocks = new Block[]{(Block)BlockRegistry.CRUST.get()}) {
            if (blockState.func_177230_c() != b) continue;
            blockIsValid = true;
        }
        if (SculkHorde.DEBUG_MODE && DEBUG_THIS) {
            System.out.println("\nAttempted to Place " + ((Object)((Object)this)).getClass().toString() + " at " + blockPos.toString() + "\nblockIsValid " + blockIsValid + "\n");
        }
        return blockIsValid;
    }

    public static enum growthStage {
        immature,
        mature;

    }
}

