/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.tileentity.SculkBeeNestTile;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SculkBeeNestBlock
extends BeehiveBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty CLOSED = BooleanProperty.func_177716_a((String)"closed");
    public static final IntegerProperty HONEY_LEVEL = IntegerProperty.func_177719_a((String)"honey_level", (int)0, (int)5);
    public static Material MATERIAL = Material.field_151585_k;
    public static MaterialColor MAP_COLOR = MaterialColor.field_151679_y;
    public static float HARDNESS = 4.0f;
    public static float BLAST_RESISTANCE = 0.5f;
    public static ToolType PREFERRED_TOOL = ToolType.HOE;
    public static int HARVEST_LEVEL = -1;

    public SculkBeeNestBlock(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf(true)));
    }

    public SculkBeeNestBlock() {
        this(SculkBeeNestBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_185859_l).func_226896_b_().func_222380_e();
    }

    public static boolean isNestClosed(BlockState blockState) {
        return blockState.func_235901_b_((Property)CLOSED) && blockState.func_203425_a((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get()) && (Boolean)blockState.func_177229_b((Property)CLOSED) != false;
    }

    public static void setNestClosed(ServerWorld world, BlockState blockState, BlockPos position) {
        if (!blockState.func_235901_b_((Property)CLOSED) || !blockState.func_203425_a((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get())) {
            return;
        }
        world.func_180501_a(position, (BlockState)blockState.func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf(true)), 3);
    }

    public static void setNestOpen(ServerWorld world, BlockState blockState, BlockPos position) {
        if (!blockState.func_235901_b_((Property)CLOSED) || !blockState.func_203425_a((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get())) {
            return;
        }
        world.func_180501_a(position, (BlockState)blockState.func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void func_220082_b(BlockState pState, World pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.func_220082_b(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pLevel.func_201670_d() && pLevel.equals(ServerLifecycleHooks.getCurrentServer().func_241755_D_())) {
            SculkHorde.gravemind.getGravemindMemory().addBeeNestToMemory(pPos);
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new SculkBeeNestTile();
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state2, IBlockReader world) {
        return this.func_196283_a_(world);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState func_185499_a(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.func_206870_a((Property)FACING, (Comparable)pRotation.func_185831_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState pState, Mirror pMirror) {
        return pState.func_185907_a(pMirror.func_185800_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> pBuilder) {
        pBuilder.func_206894_a(new Property[]{FACING, CLOSED, HONEY_LEVEL});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader iBlockReader, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sculkhorde.sculk_bee_nest"));
    }
}

