/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.block.CrustBlock;
import com.github.sculkhorde.core.ItemRegistry;
import com.github.sculkhorde.core.ParticleRegistry;
import com.github.sculkhorde.core.TileEntityRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;

public class SculkBeeNestCellBlock
extends Block
implements IForgeBlock {
    public static Material MATERIAL = Material.field_151585_k;
    public static MaterialColor MAP_COLOR = CrustBlock.MAP_COLOR;
    public static float HARDNESS = 50.0f;
    public static float BLAST_RESISTANCE = 10.0f;
    public static ToolType PREFERRED_TOOL = ToolType.SHOVEL;
    public static int HARVEST_LEVEL = -1;
    public static final IntegerProperty MATURE = IntegerProperty.func_177719_a((String)"mature", (int)0, (int)3);

    public SculkBeeNestCellBlock(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)MATURE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MATURE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)MATURE, (Comparable)Integer.valueOf(0));
    }

    public SculkBeeNestCellBlock() {
        this(SculkBeeNestCellBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        AbstractBlock.Properties prop = AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_185850_c);
        return prop;
    }

    public boolean func_149653_t(BlockState blockState) {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state2, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public boolean hasTileEntity(BlockState state2) {
        return true;
    }

    public boolean isMature(BlockState pState) {
        return (Integer)pState.func_177229_b((Property)MATURE) != 0;
    }

    public void setMature(World pLevel, BlockState pState, BlockPos pPos) {
        Random random = new Random();
        pLevel.func_180501_a(pPos, (BlockState)pState.func_206870_a((Property)MATURE, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), 3);
    }

    public void resetMature(World pLevel, BlockState pState, BlockPos pPos) {
        pLevel.func_180501_a(pPos, (BlockState)pState.func_206870_a((Property)MATURE, (Comparable)Integer.valueOf(0)), 3);
    }

    public ActionResultType func_225533_a_(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer, Hand pHand, BlockRayTraceResult pHit) {
        ItemStack itemstack = pPlayer.func_184586_b(pHand);
        if (this.isMature(pState) && itemstack.func_77973_b() == Items.field_151097_aZ) {
            pLevel.func_184148_a(pPlayer, pPlayer.func_226277_ct_(), pPlayer.func_226278_cu_(), pPlayer.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            SculkBeeNestCellBlock.dropResin(pLevel, pPos);
            itemstack.func_222118_a(1, (LivingEntity)pPlayer, p_226874_1_ -> p_226874_1_.func_213334_d(pHand));
            this.resetMature(pLevel, pState, pPos);
        }
        return ActionResultType.func_233537_a_((boolean)pLevel.field_72995_K);
    }

    public static void dropResin(World pLevel, BlockPos pPos) {
        SculkBeeNestCellBlock.func_180635_a((World)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((IItemProvider)ItemRegistry.SCULK_RESIN.get(), 1));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state2, IBlockReader world) {
        return ((TileEntityType)TileEntityRegistry.SCULK_BEE_NEST_CELL_TILE.get()).func_200968_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pPos, Random randIn) {
        BlockPos blockpos = pPos.func_177984_a();
        if (worldIn.func_180495_p(blockpos).func_196958_f() && !worldIn.func_180495_p(blockpos).func_200015_d((IBlockReader)worldIn, blockpos)) {
            if (randIn.nextInt(50) == 0) {
                double d0 = (double)pPos.func_177958_n() + randIn.nextDouble();
                double d1 = (double)pPos.func_177956_o() + 1.0;
                double d2 = (double)pPos.func_177952_p() + randIn.nextDouble();
                worldIn.func_195594_a((IParticleData)ParticleRegistry.SCULK_CRUST_PARTICLE.get(), d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + randIn.nextFloat() * 0.2f, 0.9f + randIn.nextFloat() * 0.15f, false);
            }
            if (randIn.nextInt(100) == 0) {
                worldIn.func_184134_a((double)pPos.func_177958_n(), (double)pPos.func_177956_o(), (double)pPos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + randIn.nextFloat() * 0.2f, 0.9f + randIn.nextFloat() * 0.15f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader iBlockReader, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sculkhorde.sculk_bee_nest_cell"));
    }
}

