/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.ParticleRegistry;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;

public class SculkFloraBlock
extends BushBlock
implements IForgeBlock {
    public static Material MATERIAL = Material.field_151585_k;
    public static MaterialColor MAP_COLOR = MaterialColor.field_193572_X;
    public static float HARDNESS = 3.0f;
    public static float BLAST_RESISTANCE = 6.0f;
    public static ToolType PREFERRED_TOOL = ToolType.HOE;
    public static int HARVEST_LEVEL = 3;

    public SculkFloraBlock(AbstractBlock.Properties prop) {
        super(prop);
    }

    public SculkFloraBlock() {
        this(SculkFloraBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_185850_c).func_200942_a().func_200946_b();
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Random random;
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (worldIn.field_72995_K && (random = new Random()).nextInt(10) == 0) {
            worldIn.func_195594_a((IParticleData)ParticleRegistry.SCULK_CRUST_PARTICLE.get(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (random.nextDouble() - 0.5) * 3.0, (random.nextDouble() - 0.5) * 3.0, (random.nextDouble() - 0.5) * 3.0);
        }
    }

    protected boolean func_200014_a_(BlockState blockState, IBlockReader iBlockReader, BlockPos pos) {
        Block[] validBlocks;
        for (Block b : validBlocks = new Block[]{(Block)BlockRegistry.CRUST.get(), (Block)BlockRegistry.INFESTED_STONE_DORMANT.get()}) {
            if (blockState.func_177230_c() != b) continue;
            return true;
        }
        return false;
    }

    public void placeBlockHere(ServerWorld world, BlockPos targetPos) {
        if (this.func_200014_a_(world.func_180495_p(targetPos.func_177977_b()), (IBlockReader)world, targetPos.func_177977_b()) && world.func_180495_p(targetPos).func_196958_f()) {
            world.func_175656_a(targetPos, this.func_176223_P());
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return pathType == PathType.AIR && !this.field_235688_at_ ? true : super.func_196266_a(blockState, iBlockReader, blockPos, pathType);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader iBlockReader, BlockPos pos) {
        return true;
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public boolean canBeReplacedByLeaves(BlockState state2, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean func_225541_a_(BlockState pState, Fluid pFluid) {
        return true;
    }

    public boolean canBeReplacedByLogs(BlockState state2, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean func_196253_a(BlockState pState, BlockItemUseContext pUseContext) {
        return true;
    }
}

