/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.common.tileentity.SculkMassTile;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.TileEntityRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;

public class SculkMassBlock
extends SculkFloraBlock
implements IForgeBlock {
    public static Material MATERIAL = Material.field_151585_k;
    public static MaterialColor MAP_COLOR = MaterialColor.field_151679_y;
    public static float HARDNESS = 0.6f;
    public static float BLAST_RESISTANCE = 0.5f;
    public static ToolType PREFERRED_TOOL = ToolType.HOE;
    public static int HARVEST_LEVEL = -1;
    public static final float SCULK_HOARD_MASS_TAX = 0.33333334f;
    public static double HEALTH_ABSORB_MULTIPLIER = 3.0;
    public static int infestedChildBlockMaxSpreadAttempts = 10;

    public SculkMassBlock(AbstractBlock.Properties prop) {
        super(prop);
    }

    public SculkMassBlock() {
        this(SculkMassBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_185859_l).func_226896_b_().func_222380_e();
    }

    public void spawn(World world, BlockPos originPos, float victimHealth) {
        int attempts;
        boolean DEBUG_THIS = false;
        BlockPos placementPos = originPos.func_177984_a();
        int MAX_ATTEMPTS = 64;
        for (attempts = 0; world.func_180495_p(placementPos.func_177977_b()).func_227032_a_((Fluid)Fluids.field_204546_a) && attempts <= MAX_ATTEMPTS; ++attempts) {
            placementPos = placementPos.func_177977_b();
        }
        if (attempts < MAX_ATTEMPTS && !world.func_180495_p(placementPos).equals(this.func_176223_P())) {
            world.func_175656_a(placementPos, this.func_176223_P());
            SculkMassTile thisTile = this.getTileEntity(world, placementPos);
            int totalMassPreTax = (int)((double)victimHealth * HEALTH_ABSORB_MULTIPLIER);
            int totalMassTax = (int)((float)totalMassPreTax * 0.33333334f);
            int totalMassAfterTax = totalMassPreTax - totalMassTax;
            SculkHorde.gravemind.getGravemindMemory().addSculkAccumulatedMass(totalMassTax);
            if (SculkHorde.DEBUG_MODE && DEBUG_THIS) {
                System.out.println("\ntotalMassPreTax: " + totalMassPreTax + "\ntotalMassTax: " + totalMassTax + "\ntotalMassAfterTax: " + totalMassAfterTax + "\nGlobal Sculk Mass: " + SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass());
            }
            if (thisTile != null) {
                thisTile.addStoredSculkMass(totalMassAfterTax);
            } else {
                System.out.println("Attempted to Access NULL tile at " + placementPos + "which is of blockstate " + world.func_180495_p(placementPos));
            }
            SculkHorde.infestationConversionTable.infectBlock((ServerWorld)world, originPos.func_177977_b());
        }
    }

    public boolean func_149653_t(BlockState blockState) {
        return false;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos thisBlockPos, Random random) {
    }

    public SculkMassTile getTileEntity(World world, BlockPos thisBlockPos) {
        TileEntity tileEntity = world.func_175625_s(thisBlockPos);
        SculkMassTile thisTile = null;
        try {
            thisTile = (SculkMassTile)world.func_175625_s(thisBlockPos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return thisTile;
    }

    public BlockState getToolModifiedState(BlockState state2, World world, BlockPos pos, PlayerEntity player, ItemStack stack, ToolType toolType) {
        if (SculkHorde.DEBUG_MODE) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SculkMassTile && tile != null) {
                String debug_text = "Block at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ") getStoredSculkMass: " + ((SculkMassTile)tile).getStoredSculkMass();
                player.func_146105_b((ITextComponent)new StringTextComponent(debug_text), false);
            } else {
                System.out.println("Error accessing tile entity");
            }
        }
        return null;
    }

    @Override
    protected boolean func_200014_a_(BlockState blockState, IBlockReader iBlockReader, BlockPos pos) {
        return !blockState.func_227032_a_((Fluid)Fluids.field_204546_a);
    }

    public boolean canCreatureSpawn(BlockState state2, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state2, IBlockReader world) {
        return ((TileEntityType)TileEntityRegistry.SCULK_MASS_TILE.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state2) {
        return true;
    }

    @Override
    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.NONE;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    }
}

