/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.block.CrustBlock;
import com.github.sculkhorde.common.tileentity.SculkNodeTile;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.TileEntityRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SculkNodeBlock
extends Block
implements IForgeBlock {
    public static Material MATERIAL = Material.field_151585_k;
    public static MaterialColor MAP_COLOR = CrustBlock.MAP_COLOR;
    public static float HARDNESS = 50.0f;
    public static float BLAST_RESISTANCE = 10.0f;
    public static ToolType PREFERRED_TOOL = ToolType.SHOVEL;
    public static int HARVEST_LEVEL = 3;

    public SculkNodeBlock(AbstractBlock.Properties prop) {
        super(prop);
    }

    public SculkNodeBlock() {
        this(SculkNodeBlock.getProperties());
    }

    public static void FindAreaAndPlaceNode(ServerWorld world, BlockPos searchOrigin) {
        BlockPos newOrigin = new BlockPos(searchOrigin.func_177958_n(), 40, searchOrigin.func_177952_p());
        world.func_175656_a(newOrigin, ((SculkNodeBlock)BlockRegistry.SCULK_NODE_BLOCK.get()).func_176223_P());
        SculkHorde.gravemind.getGravemindMemory().addNodeToMemory(newOrigin);
        EntityType.field_200728_aG.func_220331_a(world, null, null, newOrigin, SpawnReason.SPAWNER, true, true);
    }

    public void func_180633_a(World world, BlockPos bp, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.func_180633_a(world, bp, blockState, entity, itemStack);
        if (!world.func_201670_d() && world.equals(ServerLifecycleHooks.getCurrentServer().func_241755_D_())) {
            SculkHorde.gravemind.getGravemindMemory().addNodeToMemory(bp);
        }
    }

    public boolean func_149653_t(BlockState blockState) {
        return false;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos bp, Random random) {
        SculkHorde.gravemind.getGravemindMemory().addSculkAccumulatedMass(1);
    }

    public boolean canCreatureSpawn(BlockState state2, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public static AbstractBlock.Properties getProperties() {
        AbstractBlock.Properties prop = AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_185850_c);
        return prop;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state2, IBlockReader world) {
        return ((TileEntityType)TileEntityRegistry.SCULK_BRAIN_TILE.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state2) {
        return true;
    }

    public void func_220082_b(BlockState state2, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof SculkNodeTile && !worldIn.func_201670_d()) {
            ((SculkNodeTile)tile).forceLoadChunksInRadius((ServerWorld)worldIn, pos, worldIn.func_217349_x((BlockPos)pos).func_76632_l().field_77276_a, worldIn.func_217349_x((BlockPos)pos).func_76632_l().field_77275_b);
        }
        if (worldIn.func_201670_d()) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_219604_Z, SoundCategory.BLOCKS, 1.0f, 1.0f);
            for (PlayerEntity player : worldIn.func_217369_A()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.sculk_horde.node_placed"), true);
            }
        }
    }

    public void func_196243_a(BlockState state2, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof SculkNodeTile && !worldIn.func_201670_d()) {
            ((SculkNodeTile)tile).unloadChunksInRadius((ServerWorld)worldIn, pos, worldIn.func_217349_x((BlockPos)pos).func_76632_l().field_77276_a, worldIn.func_217349_x((BlockPos)pos).func_76632_l().field_77275_b);
        }
        super.func_196243_a(state2, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader iBlockReader, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sculkhorde.sculk_brain"));
    }
}

