/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.core.DamageSourceRegistry;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;

public class SpikeBlock
extends SculkFloraBlock
implements IForgeBlock {
    public static Material MATERIAL = Material.field_151576_e;
    public static MaterialColor MAP_COLOR = MaterialColor.field_193561_M;
    public static float HARDNESS = 4.0f;
    public static float BLAST_RESISTANCE = 6.0f;
    public static ToolType PREFERRED_TOOL = ToolType.PICKAXE;
    public static int HARVEST_LEVEL = 3;
    public static int INFECT_DURATION = 500;
    public static int INFECT_LEVEL = 1;

    public SpikeBlock(AbstractBlock.Properties prop) {
        super(prop);
    }

    public SpikeBlock() {
        this(SpikeBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_185859_l).func_200942_a().func_235859_g_();
    }

    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        if (!(entity instanceof LivingEntity) || world.field_72995_K) {
            return;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)entity)) {
            return;
        }
        entity.func_213295_a(blockState, new Vector3d((double)0.8f, 0.75, (double)0.8f));
        if (entity.field_70142_S != entity.func_226277_ct_() || entity.field_70136_U != entity.func_226281_cx_()) {
            double d0 = Math.abs(entity.func_226277_ct_() - entity.field_70142_S);
            double d1 = Math.abs(entity.func_226281_cx_() - entity.field_70136_U);
            if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                entity.func_70097_a(DamageSourceRegistry.SCULK_SPIKE, 1.0f);
                ((LivingEntity)entity).func_195064_c(new EffectInstance((Effect)EffectRegistry.SCULK_INFECTION.get(), INFECT_DURATION, INFECT_LEVEL));
                world.func_175655_b(blockPos, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader iBlockReader, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sculkhorde.spike"));
    }
}

