/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.core.BlockRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;

public class VeinBlock
extends VineBlock
implements IForgeBlock {
    public static Material MATERIAL = Material.field_151585_k;
    public static MaterialColor MAP_COLOR = MaterialColor.field_151649_A;
    public static float HARDNESS = 0.6f;
    public static float BLAST_RESISTANCE = 0.6f;
    public static ToolType PREFERRED_TOOL = ToolType.HOE;
    public static int HARVEST_LEVEL = 3;

    public VeinBlock(AbstractBlock.Properties prop) {
        super(prop);
    }

    public VeinBlock() {
        this(VeinBlock.getProperties());
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)MAP_COLOR).func_200948_a(HARDNESS, BLAST_RESISTANCE).harvestTool(PREFERRED_TOOL).harvestLevel(HARVEST_LEVEL).func_200947_a(SoundType.field_235601_w_).func_226896_b_().func_200942_a();
    }

    public boolean func_196260_a(BlockState pState, IWorldReader pLevel, BlockPos pPos) {
        World worldIn = (World)pLevel;
        BlockState northBlock = worldIn.func_180495_p(pPos.func_177978_c());
        BlockState eastBlock = worldIn.func_180495_p(pPos.func_177974_f());
        BlockState southBlock = worldIn.func_180495_p(pPos.func_177968_d());
        BlockState westBlock = worldIn.func_180495_p(pPos.func_177976_e());
        if (pState.func_177230_c().func_235332_a_((Block)BlockRegistry.VEIN.get())) {
            if (((Boolean)pState.func_177229_b((Property)field_176273_b)).booleanValue() && this.isValidFace(worldIn, northBlock, pPos, Direction.SOUTH)) {
                return true;
            }
            if (((Boolean)pState.func_177229_b((Property)field_176278_M)).booleanValue() && this.isValidFace(worldIn, eastBlock, pPos, Direction.WEST)) {
                return true;
            }
            if (((Boolean)pState.func_177229_b((Property)field_176279_N)).booleanValue() && this.isValidFace(worldIn, southBlock, pPos, Direction.NORTH)) {
                return true;
            }
            if (((Boolean)pState.func_177229_b((Property)field_176280_O)).booleanValue() && this.isValidFace(worldIn, westBlock, pPos, Direction.EAST)) {
                return true;
            }
        } else if (this.isValidFace(worldIn, northBlock, pPos, Direction.SOUTH) || this.isValidFace(worldIn, eastBlock, pPos, Direction.WEST) || this.isValidFace(worldIn, southBlock, pPos, Direction.NORTH) || this.isValidFace(worldIn, westBlock, pPos, Direction.EAST)) {
            return true;
        }
        return false;
    }

    public void placeBlock(World worldIn, BlockPos blockPosIn) {
        if (!worldIn.func_180495_p(blockPosIn).func_196958_f()) {
            return;
        }
        if (!this.func_196260_a(worldIn.func_180495_p(blockPosIn), (IWorldReader)worldIn, blockPosIn)) {
            return;
        }
        Block vein = (Block)BlockRegistry.VEIN.get();
        BlockState northBlock = worldIn.func_180495_p(blockPosIn.func_177978_c());
        BlockState eastBlock = worldIn.func_180495_p(blockPosIn.func_177974_f());
        BlockState southBlock = worldIn.func_180495_p(blockPosIn.func_177968_d());
        BlockState westBlock = worldIn.func_180495_p(blockPosIn.func_177976_e());
        if (this.isValidFace(worldIn, northBlock, blockPosIn, Direction.SOUTH)) {
            worldIn.func_175656_a(blockPosIn, (BlockState)vein.func_176223_P().func_206870_a((Property)field_176273_b, (Comparable)Boolean.valueOf(true)));
        } else if (this.isValidFace(worldIn, eastBlock, blockPosIn, Direction.WEST)) {
            worldIn.func_175656_a(blockPosIn, (BlockState)vein.func_176223_P().func_206870_a((Property)field_176278_M, (Comparable)Boolean.valueOf(true)));
        } else if (this.isValidFace(worldIn, southBlock, blockPosIn, Direction.NORTH)) {
            worldIn.func_175656_a(blockPosIn, (BlockState)vein.func_176223_P().func_206870_a((Property)field_176279_N, (Comparable)Boolean.valueOf(true)));
        } else if (this.isValidFace(worldIn, westBlock, blockPosIn, Direction.EAST)) {
            worldIn.func_175656_a(blockPosIn, (BlockState)vein.func_176223_P().func_206870_a((Property)field_176280_O, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean isValidFace(World worldIn, BlockState blockState, BlockPos blockPosIn, Direction direction) {
        if (!blockState.func_224755_d((IBlockReader)worldIn, blockPosIn, direction)) {
            return false;
        }
        if (blockState.func_203425_a((Block)BlockRegistry.CRUST.get())) {
            return false;
        }
        if (blockState.func_203425_a((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get())) {
            return false;
        }
        if (blockState.func_203425_a((Block)BlockRegistry.SCULK_SUMMONER_BLOCK.get())) {
            return false;
        }
        if (blockState.func_203425_a((Block)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get())) {
            return false;
        }
        if (blockState.func_203425_a((Block)BlockRegistry.SCULK_NODE_BLOCK.get())) {
            return false;
        }
        return !blockState.func_203425_a((Block)BlockRegistry.INFESTED_STONE_DORMANT.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader iBlockReader, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sculkhorde.vein"));
    }
}

