/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.SculkLivingEntity;
import com.github.sculkhorde.common.tileentity.SculkBeeNestTile;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SculkBeeHarvesterEntity
extends SculkLivingEntity
implements IAnimatable,
IFlyingAnimal {
    public static final float MAX_HEALTH = 20.0f;
    public static final float FOLLOW_RANGE = 25.0f;
    public static final float MOVEMENT_SPEED = 0.25f;
    public static final int SPAWN_Y_MAX = 15;
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(SculkBeeHarvesterEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> DATA_REMAINING_ANGER_TIME = EntityDataManager.func_187226_a(SculkBeeHarvesterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected float rollAmount;
    protected float rollAmountO;
    protected int ticksWithoutNectarSinceExitingHive;
    protected int numCropsGrownSincePollination;
    protected int remainingCooldownBeforeLocatingNewHive = 0;
    protected int remainingCooldownBeforeLocatingNewFlower = 0;
    @Nullable
    protected BlockPos savedFlowerPos = null;
    @Nullable
    protected BlockPos hivePos = null;
    protected PollinateGoal beePollinateGoal;
    protected FindBeehiveGoal goToHiveGoal;
    protected FindFlowerGoal goToKnownFlowerGoal;
    protected int underWaterTicks;
    protected final int COOLDOWN_FIND_NEW_HIVE = 1200;
    private final Predicate<BlockState> VALID_POLLINATION_BLOCKS = validBlocksPredicate -> {
        if (validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_SHROOM_CULTURE.get())) {
            return true;
        }
        return validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SMALL_SHROOM.get());
    };

    public SculkBeeHarvesterEntity(EntityType<? extends SculkBeeHarvesterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.field_70749_g = new BeeLookController((MobEntity)this);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    public SculkBeeHarvesterEntity(World worldIn) {
        this((EntityType<? extends SculkBeeHarvesterEntity>)EntityRegistry.SCULK_BEE_HARVESTER, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
        this.field_70180_af.func_187214_a(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    protected boolean func_225511_J_() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233822_e_, (double)0.6f);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 3;
    }

    @Nullable
    public BlockPos getHivePos() {
        return this.hivePos;
    }

    protected int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    protected boolean getFlag(int pFlagId) {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & pFlagId) != 0;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_226127_ab_;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_226125_Z_;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_226124_Y_;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public float func_205022_a(BlockPos pPos, IWorldReader pLevel) {
        return pLevel.func_180495_p(pPos).func_196958_f() ? 10.0f : 0.0f;
    }

    protected float func_213348_b(Pose pPose, EntitySize pSize) {
        return this.func_70631_g_() ? pSize.field_220316_b * 0.5f : pSize.field_220316_b * 0.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.5f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.2f));
    }

    public SculkBeeHarvesterEntity getBreedOffspring(ServerWorld pServerLevel, AgeableEntity pMate) {
        return (SculkBeeHarvesterEntity)EntityRegistry.SCULK_BEE_HARVESTER.func_200721_a((World)pServerLevel);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    public BlockPos getSavedFlowerPos() {
        return this.savedFlowerPos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRollAmount(float pPartialTick) {
        return MathHelper.func_219799_g((float)pPartialTick, (float)this.rollAmountO, (float)this.rollAmount);
    }

    protected void resetNumCropsGrownSincePollination() {
        this.numCropsGrownSincePollination = 0;
    }

    protected void incrementNumCropsGrownSincePollination() {
        ++this.numCropsGrownSincePollination;
    }

    protected void setHasNectar(boolean pHasNectar) {
        if (pHasNectar) {
            this.resetTicksWithoutNectarSinceExitingHive();
        }
        this.setFlag(8, pHasNectar);
    }

    protected void setRolling(boolean pIsRolling) {
        this.setFlag(2, pIsRolling);
    }

    public void setSavedFlowerPos(BlockPos pSavedFlowerPos) {
        this.savedFlowerPos = pSavedFlowerPos;
    }

    protected void setFlag(int pFlagId, boolean pValue) {
        if (pValue) {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) | pFlagId)));
        } else {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & ~pFlagId)));
        }
    }

    public void resetTicksWithoutNectarSinceExitingHive() {
        this.ticksWithoutNectarSinceExitingHive = 0;
    }

    protected void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    public boolean hasHive() {
        return this.hivePos != null;
    }

    protected boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        TileEntity tileentity = this.field_70170_p.func_175625_s(this.hivePos);
        return tileentity instanceof SculkBeeNestTile;
    }

    protected boolean doesHiveHaveSpace(BlockPos pHivePos) {
        TileEntity tileentity = this.field_70170_p.func_175625_s(pHivePos);
        if (tileentity instanceof SculkBeeNestTile) {
            return !((SculkBeeNestTile)tileentity).isFull();
        }
        if (tileentity == null) {
            return false;
        }
        return false;
    }

    public boolean hasNectar() {
        return this.getFlag(8);
    }

    protected boolean isRolling() {
        return this.getFlag(2);
    }

    protected boolean isTooFarAway(BlockPos pPos) {
        return !this.closerThan(pPos, 32);
    }

    protected boolean isFlowerValid(BlockPos pPos) {
        return this.field_70170_p.func_195588_v(pPos) & this.getFlowerPredicate().test(this.field_70170_p.func_180495_p(pPos));
    }

    public boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    protected boolean isTiredOfLookingForNectar() {
        return this.ticksWithoutNectarSinceExitingHive > 3600;
    }

    protected boolean wantsToEnterHive() {
        if (!this.beePollinateGoal.isPollinating() && this.func_70638_az() == null) {
            boolean flag = this.isTiredOfLookingForNectar() || this.hasNectar();
            return flag;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.field_70146_Z.nextFloat() < 0.05f) {
            for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                this.spawnFluidParticle(this.field_70170_p, this.func_226277_ct_() - (double)0.3f, this.func_226277_ct_() + (double)0.3f, this.func_226281_cx_() - (double)0.3f, this.func_226281_cx_() + (double)0.3f, this.func_226283_e_(0.5), (IParticleData)ParticleTypes.field_229430_aj_);
            }
        }
        this.updateRollAmount();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.remainingCooldownBeforeLocatingNewHive > 0) {
                --this.remainingCooldownBeforeLocatingNewHive;
            }
            if (this.remainingCooldownBeforeLocatingNewFlower > 0) {
                --this.remainingCooldownBeforeLocatingNewFlower;
            }
            boolean flag = this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 4.0;
            this.setRolling(flag);
            if (this.field_70173_aa % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
        }
    }

    protected void func_70619_bc() {
        this.underWaterTicks = this.func_203005_aq() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (!this.hasNectar()) {
            ++this.ticksWithoutNectarSinceExitingHive;
        }
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public static boolean passSpawnCondition(EntityType<? extends CreatureEntity> config, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        if (reason != SpawnReason.CHUNK_GENERATION && reason != SpawnReason.NATURAL) {
            return false;
        }
        return pos.func_177956_o() <= 15 || world.func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistry.CRUST.get();
    }

    public void func_184651_r() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.field_70714_bg.func_75776_a(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.field_70715_bh.func_75776_a(priority, targetSelectorPayload[priority]);
        }
    }

    private Goal[] goalSelectorPayload() {
        this.beePollinateGoal = new PollinateGoal();
        this.goToHiveGoal = new FindBeehiveGoal();
        this.goToKnownFlowerGoal = new FindFlowerGoal();
        Goal[] goals = new Goal[]{new UpdateBeehiveGoal(), new EnterBeehiveGoal(), this.beePollinateGoal, this.goToHiveGoal, this.goToKnownFlowerGoal, new LookRandomlyGoal((MobEntity)this), new WanderGoal(), new SwimGoal((MobEntity)this)};
        return goals;
    }

    private Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{};
        return goals;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sculk_bee.flying", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public void func_213281_b(CompoundNBT pCompound) {
        super.func_213281_b(pCompound);
        if (this.hasHive()) {
            pCompound.func_218657_a("HivePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getHivePos()));
        }
        if (this.hasSavedFlowerPos()) {
            pCompound.func_218657_a("FlowerPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getSavedFlowerPos()));
        }
        pCompound.func_74757_a("HasNectar", this.hasNectar());
        pCompound.func_74768_a("TicksSincePollination", this.ticksWithoutNectarSinceExitingHive);
        pCompound.func_74768_a("CropsGrownSincePollination", this.numCropsGrownSincePollination);
    }

    public void func_70037_a(CompoundNBT pCompound) {
        this.hivePos = null;
        if (pCompound.func_74764_b("HivePos")) {
            this.hivePos = NBTUtil.func_186861_c((CompoundNBT)pCompound.func_74775_l("HivePos"));
        }
        this.savedFlowerPos = null;
        if (pCompound.func_74764_b("FlowerPos")) {
            this.savedFlowerPos = NBTUtil.func_186861_c((CompoundNBT)pCompound.func_74775_l("FlowerPos"));
        }
        super.func_70037_a(pCompound);
        this.setHasNectar(pCompound.func_74767_n("HasNectar"));
        this.ticksWithoutNectarSinceExitingHive = pCompound.func_74762_e("TicksSincePollination");
        this.numCropsGrownSincePollination = pCompound.func_74762_e("CropsGrownSincePollination");
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    protected PathNavigator func_175447_b(World pLevel) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, pLevel){

            public boolean func_188555_b(BlockPos pPos) {
                return !this.field_75513_b.func_180495_p(pPos.func_177977_b()).func_196958_f();
            }

            public void func_75501_e() {
                if (!SculkBeeHarvesterEntity.this.beePollinateGoal.isPollinating()) {
                    super.func_75501_e();
                }
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public boolean func_225503_b_(float pFallDistance, float pDamageMultiplier) {
        return false;
    }

    protected void func_184231_a(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public void dropOffNectar() {
        this.setHasNectar(false);
        this.resetNumCropsGrownSincePollination();
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        if (this.func_180431_b(pSource)) {
            return false;
        }
        Entity entity = pSource.func_76346_g();
        if (!this.field_70170_p.field_72995_K) {
            this.beePollinateGoal.stopPollinating();
        }
        return super.func_70097_a(pSource, pAmount);
    }

    protected void func_180466_bG(ITag<Fluid> pFluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    protected boolean closerThan(BlockPos pPos, int pDistance) {
        return pPos.func_218141_a((Vector3i)this.func_233580_cy_(), (double)pDistance);
    }

    protected void spawnFluidParticle(World pLevel, double pStartX, double pEndX, double pStartZ, double pEndZ, double pPosY, IParticleData pParticleOption) {
        pLevel.func_195594_a(pParticleOption, MathHelper.func_219803_d((double)pLevel.field_73012_v.nextDouble(), (double)pStartX, (double)pEndX), pPosY, MathHelper.func_219803_d((double)pLevel.field_73012_v.nextDouble(), (double)pStartZ, (double)pEndZ), 0.0, 0.0, 0.0);
    }

    protected void pathfindRandomlyTowards(BlockPos pPos) {
        Vector3d vector3d1;
        Vector3d targetPos = Vector3d.func_237492_c_((Vector3i)pPos);
        int i = 0;
        BlockPos blockpos = this.func_233580_cy_();
        int height = (int)targetPos.field_72448_b - blockpos.func_177956_o();
        if (height > 2) {
            i = 4;
        } else if (height < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.func_218139_n((Vector3i)pPos);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vector3d1 = RandomPositionGenerator.func_226344_b_((CreatureEntity)this, (int)k, (int)l, (int)i, (Vector3d)targetPos, (double)0.3141592741012573)) != null) {
            this.field_70699_by.func_226335_a_(0.5f);
            this.field_70699_by.func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, 1.0);
        }
    }

    public void func_70623_bb() {
    }

    protected Predicate<BlockState> getFlowerPredicate() {
        return this.VALID_POLLINATION_BLOCKS;
    }

    protected class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return SculkBeeHarvesterEntity.this.field_70699_by.func_75500_f() && SculkBeeHarvesterEntity.this.savedFlowerPos == null && SculkBeeHarvesterEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return SculkBeeHarvesterEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.findPos();
            if (vector3d != null) {
                SculkBeeHarvesterEntity.this.field_70699_by.func_75484_a(SculkBeeHarvesterEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d findPos() {
            Vector3d vector3d;
            if (SculkBeeHarvesterEntity.this.isHiveValid() && !SculkBeeHarvesterEntity.this.closerThan(SculkBeeHarvesterEntity.this.hivePos, 9)) {
                Vector3d vector3d1 = Vector3d.func_237489_a_((Vector3i)SculkBeeHarvesterEntity.this.hivePos);
                vector3d = vector3d1.func_178788_d(SculkBeeHarvesterEntity.this.func_213303_ch()).func_72432_b();
            } else {
                vector3d = SculkBeeHarvesterEntity.this.func_70676_i(0.0f);
            }
            int i = 8;
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)SculkBeeHarvesterEntity.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)SculkBeeHarvesterEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }

    protected class UpdateBeehiveGoal
    extends PassiveGoal {
        private final Predicate<BlockState> VALID_HIVE_BLOCKS;

        protected UpdateBeehiveGoal() {
            this.VALID_HIVE_BLOCKS = validBlocksPredicate -> validBlocksPredicate.func_203425_a((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get());
        }

        @Override
        public boolean canBeeUse() {
            return SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewHive == 0 && !SculkBeeHarvesterEntity.this.hasHive();
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        public void func_75249_e() {
            SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewHive = 1200;
            List<BlockPos> list = this.findNearbyHivesWithSpace();
            if (!list.isEmpty()) {
                for (BlockPos blockpos : list) {
                    if (SculkBeeHarvesterEntity.this.goToHiveGoal.isTargetBlacklisted(blockpos)) continue;
                    SculkBeeHarvesterEntity.this.hivePos = blockpos;
                    return;
                }
                SculkBeeHarvesterEntity.this.goToHiveGoal.clearBlacklist();
                SculkBeeHarvesterEntity.this.hivePos = list.get(0);
            }
        }

        private List<BlockPos> findNearbyHivesWithSpace() {
            ArrayList<BlockPos> list = BlockAlgorithms.getBlocksInArea((ServerWorld)SculkBeeHarvesterEntity.this.field_70170_p, SculkBeeHarvesterEntity.this.func_233580_cy_(), this.VALID_HIVE_BLOCKS, 20.0);
            for (int index = 0; index < list.size(); ++index) {
                if (SculkBeeHarvesterEntity.this.doesHiveHaveSpace((BlockPos)list.get(index))) continue;
                list.remove(index);
                --index;
            }
            return list;
        }
    }

    protected class FindFlowerGoal
    extends PassiveGoal {
        private int travellingTicks;

        FindFlowerGoal() {
            this.travellingTicks = SculkBeeHarvesterEntity.this.field_70170_p.field_73012_v.nextInt(10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            return SculkBeeHarvesterEntity.this.savedFlowerPos != null && !SculkBeeHarvesterEntity.this.func_213394_dL() && this.wantsToGoToKnownFlower() && SculkBeeHarvesterEntity.this.isFlowerValid(SculkBeeHarvesterEntity.this.savedFlowerPos) && !SculkBeeHarvesterEntity.this.closerThan(SculkBeeHarvesterEntity.this.savedFlowerPos, 2);
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        public void func_75249_e() {
            this.travellingTicks = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.travellingTicks = 0;
            SculkBeeHarvesterEntity.this.field_70699_by.func_75499_g();
            SculkBeeHarvesterEntity.this.field_70699_by.func_226336_g_();
        }

        public void func_75246_d() {
            if (SculkBeeHarvesterEntity.this.savedFlowerPos != null) {
                ++this.travellingTicks;
                if (this.travellingTicks > 600) {
                    SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                } else if (!SculkBeeHarvesterEntity.this.field_70699_by.func_226337_n_()) {
                    if (SculkBeeHarvesterEntity.this.isTooFarAway(SculkBeeHarvesterEntity.this.savedFlowerPos)) {
                        SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                    } else {
                        SculkBeeHarvesterEntity.this.pathfindRandomlyTowards(SculkBeeHarvesterEntity.this.savedFlowerPos);
                    }
                }
            }
        }

        private boolean wantsToGoToKnownFlower() {
            return SculkBeeHarvesterEntity.this.ticksWithoutNectarSinceExitingHive > 2400;
        }
    }

    protected class FindBeehiveGoal
    extends PassiveGoal {
        private int travellingTicks;
        private List<BlockPos> blacklistedTargets;
        @Nullable
        private Path lastPath;
        private int ticksStuck;

        FindBeehiveGoal() {
            this.travellingTicks = SculkBeeHarvesterEntity.this.field_70170_p.field_73012_v.nextInt(10);
            this.blacklistedTargets = Lists.newArrayList();
            this.lastPath = null;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            return SculkBeeHarvesterEntity.this.hivePos != null && !SculkBeeHarvesterEntity.this.func_213394_dL() && SculkBeeHarvesterEntity.this.wantsToEnterHive() && !this.hasReachedTarget(SculkBeeHarvesterEntity.this.hivePos) && SculkBeeHarvesterEntity.this.field_70170_p.func_180495_p(SculkBeeHarvesterEntity.this.hivePos).func_203425_a((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get());
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        public void func_75249_e() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            SculkBeeHarvesterEntity.this.field_70699_by.func_75499_g();
            SculkBeeHarvesterEntity.this.field_70699_by.func_226336_g_();
        }

        public void func_75246_d() {
            if (SculkBeeHarvesterEntity.this.hivePos != null) {
                ++this.travellingTicks;
                if (!SculkBeeHarvesterEntity.this.field_70699_by.func_226337_n_()) {
                    if (!SculkBeeHarvesterEntity.this.closerThan(SculkBeeHarvesterEntity.this.hivePos, 16)) {
                        SculkBeeHarvesterEntity.this.pathfindRandomlyTowards(SculkBeeHarvesterEntity.this.hivePos);
                    } else {
                        boolean flag = this.pathfindDirectlyTowards(SculkBeeHarvesterEntity.this.hivePos);
                        if (!flag) {
                            this.dropAndBlacklistHive();
                        } else {
                            this.lastPath = SculkBeeHarvesterEntity.this.field_70699_by.func_75505_d();
                        }
                    }
                }
            }
        }

        private boolean pathfindDirectlyTowards(BlockPos pPos) {
            SculkBeeHarvesterEntity.this.field_70699_by.func_226335_a_(10.0f);
            SculkBeeHarvesterEntity.this.field_70699_by.func_75492_a((double)pPos.func_177958_n(), (double)pPos.func_177956_o(), (double)pPos.func_177952_p(), 1.0);
            return SculkBeeHarvesterEntity.this.field_70699_by.func_75505_d() != null && SculkBeeHarvesterEntity.this.field_70699_by.func_75505_d().func_224771_h();
        }

        private boolean isTargetBlacklisted(BlockPos pPos) {
            return this.blacklistedTargets.contains(pPos);
        }

        private void blacklistTarget(BlockPos pPos) {
            this.blacklistedTargets.add(pPos);
            while (this.blacklistedTargets.size() > 3) {
                this.blacklistedTargets.remove(0);
            }
        }

        private void clearBlacklist() {
            this.blacklistedTargets.clear();
        }

        private void dropAndBlacklistHive() {
            if (SculkBeeHarvesterEntity.this.hivePos != null) {
                this.blacklistTarget(SculkBeeHarvesterEntity.this.hivePos);
            }
            this.dropHive();
        }

        private void dropHive() {
            SculkBeeHarvesterEntity.this.hivePos = null;
            SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewHive = 1200;
        }

        private boolean hasReachedTarget(BlockPos pPos) {
            if (SculkBeeHarvesterEntity.this.closerThan(pPos, 2)) {
                return true;
            }
            Path path = SculkBeeHarvesterEntity.this.field_70699_by.func_75505_d();
            return path != null && path.func_224770_k().equals((Object)pPos) && path.func_224771_h() && path.func_75879_b();
        }
    }

    protected class EnterBeehiveGoal
    extends PassiveGoal {
        protected EnterBeehiveGoal() {
        }

        @Override
        public boolean canBeeUse() {
            TileEntity tileentity;
            if (SculkBeeHarvesterEntity.this.hasHive() && SculkBeeHarvesterEntity.this.wantsToEnterHive() && SculkBeeHarvesterEntity.this.hivePos.func_218137_a((IPosition)SculkBeeHarvesterEntity.this.func_213303_ch(), 2.0) && (tileentity = SculkBeeHarvesterEntity.this.field_70170_p.func_175625_s(SculkBeeHarvesterEntity.this.hivePos)) instanceof SculkBeeNestTile) {
                SculkBeeNestTile beehivetileentity = (SculkBeeNestTile)tileentity;
                if (!beehivetileentity.isFull()) {
                    return true;
                }
                SculkBeeHarvesterEntity.this.hivePos = null;
            }
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        public void func_75249_e() {
            TileEntity tileentity = SculkBeeHarvesterEntity.this.field_70170_p.func_175625_s(SculkBeeHarvesterEntity.this.hivePos);
            if (tileentity instanceof SculkBeeNestTile) {
                SculkBeeNestTile beehivetileentity = (SculkBeeNestTile)tileentity;
                beehivetileentity.addOccupant((Entity)SculkBeeHarvesterEntity.this);
            }
        }
    }

    protected class PollinateGoal
    extends PassiveGoal {
        protected int successfulPollinatingTicks;
        protected int lastSoundPlayedTick;
        protected boolean pollinating;
        protected Vector3d hoverPos;
        protected int pollinatingTicks;

        PollinateGoal() {
            this.successfulPollinatingTicks = 0;
            this.lastSoundPlayedTick = 0;
            this.pollinatingTicks = 0;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            if (SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewFlower > 0) {
                return false;
            }
            if (SculkBeeHarvesterEntity.this.hasNectar()) {
                return false;
            }
            if (SculkBeeHarvesterEntity.this.field_70146_Z.nextFloat() < 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.findNearbyFlower();
            if (optional.isPresent()) {
                SculkBeeHarvesterEntity.this.savedFlowerPos = optional.get();
                SculkBeeHarvesterEntity.this.field_70699_by.func_75492_a((double)SculkBeeHarvesterEntity.this.savedFlowerPos.func_177958_n() + 0.5, (double)SculkBeeHarvesterEntity.this.savedFlowerPos.func_177956_o() + 0.5, (double)SculkBeeHarvesterEntity.this.savedFlowerPos.func_177952_p() + 0.5, (double)1.2f);
                return true;
            }
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            if (!this.pollinating) {
                return false;
            }
            if (!SculkBeeHarvesterEntity.this.hasSavedFlowerPos()) {
                return false;
            }
            if (this.hasPollinatedLongEnough()) {
                return true;
            }
            if (SculkBeeHarvesterEntity.this.field_70173_aa % 20 == 0 && !SculkBeeHarvesterEntity.this.isFlowerValid(SculkBeeHarvesterEntity.this.savedFlowerPos)) {
                SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                return false;
            }
            return true;
        }

        protected boolean hasPollinatedLongEnough() {
            return this.successfulPollinatingTicks > 400;
        }

        protected boolean isPollinating() {
            return this.pollinating;
        }

        protected void stopPollinating() {
            this.pollinating = false;
        }

        public void func_75249_e() {
            this.successfulPollinatingTicks = 0;
            this.pollinatingTicks = 0;
            this.lastSoundPlayedTick = 0;
            this.pollinating = true;
            SculkBeeHarvesterEntity.this.resetTicksWithoutNectarSinceExitingHive();
        }

        public void func_75251_c() {
            if (this.hasPollinatedLongEnough()) {
                SculkBeeHarvesterEntity.this.setHasNectar(true);
            }
            this.pollinating = false;
            SculkBeeHarvesterEntity.this.field_70699_by.func_75499_g();
            SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }

        public void func_75246_d() {
            int MAX_POLLINATION_TICKS = 600;
            ++this.pollinatingTicks;
            if (this.pollinatingTicks > MAX_POLLINATION_TICKS) {
                SculkBeeHarvesterEntity.this.savedFlowerPos = null;
            } else {
                Vector3d offsetFlowerPos = Vector3d.func_237492_c_((Vector3i)SculkBeeHarvesterEntity.this.savedFlowerPos).func_72441_c(0.0, (double)0.6f, 0.0);
                if (offsetFlowerPos.func_72438_d(SculkBeeHarvesterEntity.this.func_213303_ch()) > 1.0) {
                    this.hoverPos = offsetFlowerPos;
                    this.setWantedPos();
                } else {
                    if (this.hoverPos == null) {
                        this.hoverPos = offsetFlowerPos;
                    }
                    boolean isInRangeOfFlower = SculkBeeHarvesterEntity.this.func_213303_ch().func_72438_d(this.hoverPos) <= 0.1;
                    boolean isHoverPosOffseted = true;
                    if (!isInRangeOfFlower && this.pollinatingTicks > MAX_POLLINATION_TICKS) {
                        SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                    } else {
                        if (isInRangeOfFlower) {
                            boolean randomChanceOfSuccess;
                            boolean bl = randomChanceOfSuccess = SculkBeeHarvesterEntity.this.field_70146_Z.nextInt(25) == 0;
                            if (randomChanceOfSuccess) {
                                this.hoverPos = new Vector3d(offsetFlowerPos.func_82615_a() + (double)this.getRandomOffset(), offsetFlowerPos.func_82617_b(), offsetFlowerPos.func_82616_c() + (double)this.getRandomOffset());
                                SculkBeeHarvesterEntity.this.field_70699_by.func_75499_g();
                            } else {
                                isHoverPosOffseted = false;
                            }
                            SculkBeeHarvesterEntity.this.func_70671_ap().func_220679_a(offsetFlowerPos.func_82615_a(), offsetFlowerPos.func_82617_b(), offsetFlowerPos.func_82616_c());
                        }
                        if (isHoverPosOffseted) {
                            this.setWantedPos();
                        }
                        ++this.successfulPollinatingTicks;
                        if (SculkBeeHarvesterEntity.this.field_70146_Z.nextFloat() < 0.05f && this.successfulPollinatingTicks > this.lastSoundPlayedTick + 60) {
                            this.lastSoundPlayedTick = this.successfulPollinatingTicks;
                            SculkBeeHarvesterEntity.this.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        protected void setWantedPos() {
            SculkBeeHarvesterEntity.this.func_70605_aq().func_75642_a(this.hoverPos.func_82615_a(), this.hoverPos.func_82617_b(), this.hoverPos.func_82616_c(), (double)0.35f);
        }

        protected float getRandomOffset() {
            return (SculkBeeHarvesterEntity.this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        protected Optional<BlockPos> findNearbyFlower() {
            return this.findNearestBlock(SculkBeeHarvesterEntity.this.getFlowerPredicate(), 32.0);
        }

        protected Optional<BlockPos> findNearestBlock(Predicate<BlockState> pPredicate, double pDistance) {
            BlockPos blockpos = SculkBeeHarvesterEntity.this.func_233580_cy_();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = 0;
            while ((double)i <= pDistance) {
                int j = 0;
                while ((double)j < pDistance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            blockpos$mutable.func_239621_a_((Vector3i)blockpos, k, i - 1, l);
                            if (blockpos.func_218141_a((Vector3i)blockpos$mutable, pDistance) && pPredicate.test(SculkBeeHarvesterEntity.this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable))) {
                                return Optional.of(blockpos$mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    public abstract class PassiveGoal
    extends Goal {
        public abstract boolean canBeeUse();

        public abstract boolean canBeeContinueToUse();

        public boolean func_75250_a() {
            return this.canBeeUse();
        }

        public boolean func_75253_b() {
            return this.canBeeContinueToUse();
        }
    }

    public class BeeLookController
    extends LookController {
        BeeLookController(MobEntity pMob) {
            super(pMob);
        }

        public void func_75649_a() {
            super.func_75649_a();
        }

        protected boolean func_220680_b() {
            return !SculkBeeHarvesterEntity.this.beePollinateGoal.isPollinating();
        }
    }
}

