/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SculkBeeInfectorEntity
extends SculkBeeHarvesterEntity
implements IAnimatable {
    public static final float MAX_HEALTH = 20.0f;
    public static final float ARMOR = 4.0f;
    public static final float ATTACK_DAMAGE = 3.0f;
    public static final float ATTACK_KNOCKBACK = 1.0f;
    public static final float FOLLOW_RANGE = 25.0f;
    public static final float MOVEMENT_SPEED = 0.5f;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final Predicate<BlockState> VALID_INFECTABLE_BLOCKS = validBlocksPredicate -> {
        if (validBlocksPredicate.func_235714_a_((ITag)BlockTags.field_226148_H_)) {
            if (validBlocksPredicate.func_203425_a(Blocks.field_196800_gd)) {
                return validBlocksPredicate.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER;
            }
            return true;
        }
        return validBlocksPredicate.func_235714_a_((ITag)BlockTags.field_219746_E) || validBlocksPredicate.func_203425_a(Blocks.field_150349_c);
    };

    public SculkBeeInfectorEntity(EntityType<? extends SculkBeeInfectorEntity> type, World worldIn) {
        super((EntityType<? extends SculkBeeHarvesterEntity>)type, worldIn);
    }

    public SculkBeeInfectorEntity(World worldIn) {
        super((EntityType<? extends SculkBeeHarvesterEntity>)EntityRegistry.SCULK_BEE_INFECTOR, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233822_e_, 1.5);
    }

    @Override
    public void func_184651_r() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.field_70714_bg.func_75776_a(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.field_70715_bh.func_75776_a(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        this.beePollinateGoal = new InfectFlowersGoal();
        this.goToHiveGoal = new SculkBeeHarvesterEntity.FindBeehiveGoal();
        this.goToKnownFlowerGoal = new SculkBeeHarvesterEntity.FindFlowerGoal();
        Goal[] goals = new Goal[]{new SculkBeeHarvesterEntity.UpdateBeehiveGoal(), new SculkBeeHarvesterEntity.EnterBeehiveGoal(), this.beePollinateGoal, this.goToHiveGoal, this.goToKnownFlowerGoal, new LookRandomlyGoal((MobEntity)this), new SculkBeeHarvesterEntity.WanderGoal(), new SwimGoal((MobEntity)this)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{};
        return goals;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sculk_bee.flying", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected boolean isFlowerValid(BlockPos pPos) {
        return this.field_70170_p.func_195588_v(pPos) & this.getFlowerPredicate().test(this.field_70170_p.func_180495_p(pPos)) & SculkHorde.infestationConversionTable.infestationTable.isNormalVariant(this.field_70170_p.func_180495_p(pPos.func_177977_b()));
    }

    @Override
    protected Predicate<BlockState> getFlowerPredicate() {
        return this.VALID_INFECTABLE_BLOCKS;
    }

    private class InfectFlowersGoal
    extends SculkBeeHarvesterEntity.PollinateGoal {
        InfectFlowersGoal() {
        }

        @Override
        public void func_75251_c() {
            if (this.hasPollinatedLongEnough()) {
                SculkBeeInfectorEntity.this.setHasNectar(true);
                BlockPos spreadPos = SculkBeeInfectorEntity.this.func_233580_cy_().func_177977_b();
                ServerWorld world = (ServerWorld)SculkBeeInfectorEntity.this.field_70170_p;
                CursorSurfaceInfectorEntity cursor = new CursorSurfaceInfectorEntity((World)world);
                cursor.func_70107_b(spreadPos.func_177958_n(), spreadPos.func_177956_o(), spreadPos.func_177952_p());
                cursor.setMaxRange(100);
                cursor.setMaxInfections(100);
                world.func_217376_c((Entity)cursor);
            }
            this.pollinating = false;
            SculkBeeInfectorEntity.this.field_70699_by.func_75499_g();
            SculkBeeInfectorEntity.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }
    }
}

