/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.SculkLivingEntity;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.SculkMiteInfectGoal;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.util.TargetParameters;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SculkMiteEntity
extends SculkLivingEntity
implements IAnimatable,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 5.0f;
    public static final float ARMOR = 1.0f;
    public static final float ATTACK_DAMAGE = 1.0f;
    public static final float ATTACK_KNOCKBACK = 1.0f;
    public static final float FOLLOW_RANGE = 30.0f;
    public static final float MOVEMENT_SPEED = 0.3f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((MobEntity)this).enableTargetPassives().enableTargetHostiles().enableMustReachTarget();
    public static int SPAWN_WEIGHT = 50;
    public static int SPAWN_MIN = 1;
    public static int SPAWN_MAX = 5;
    public static int INFECT_RANGE = 2;
    public static Effect INFECT_EFFECT = (Effect)EffectRegistry.SCULK_INFECTION.get();
    public static int INFECT_DURATION = 500;
    public static int INFECT_LEVEL = 1;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SculkMiteEntity(EntityType<? extends SculkMiteEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public SculkMiteEntity(World worldIn) {
        super(EntityRegistry.SCULK_MITE, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233826_i_, 1.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    @Override
    public boolean isIdle() {
        return this.func_70638_az() == null;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    protected void func_180429_a(BlockPos pPos, BlockState pBlock) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    public boolean func_104002_bU() {
        return true;
    }

    public static boolean passSpawnCondition(EntityType<? extends CreatureEntity> config, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        if (world.func_226658_a_(LightType.BLOCK, pos) > 8) {
            return false;
        }
        return world.func_226658_a_(LightType.SKY, pos) <= 8;
    }

    public void func_184651_r() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.field_70714_bg.func_75776_a(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.field_70715_bh.func_75776_a(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new DespawnWhenIdle(this, 60), new SwimGoal((MobEntity)this), new SculkMiteInfectGoal(this, 1.0, true), new MoveTowardsTargetGoal((CreatureEntity)this, (double)0.8f, 20.0f), new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0), new LookAtGoal((MobEntity)this, PigEntity.class, 8.0f), new LookRandomlyGoal((MobEntity)this)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((CreatureEntity)this, new Class[0]).setAlertAllies(new Class[0]), new NearestLivingEntityTargetGoal((MobEntity)this, true, true)};
        return goals;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }
}

