/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.TargetParameters;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SculkRavagerEntity
extends RavagerEntity
implements IAnimatable,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 50.0f;
    public static final float ARMOR = 4.0f;
    public static final float ATTACK_DAMAGE = 18.0f;
    public static final float ATTACK_KNOCKBACK = 5.0f;
    public static final float FOLLOW_RANGE = 50.0f;
    public static final float MOVEMENT_SPEED = 0.75f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((MobEntity)this).enableTargetHostiles().enableTargetInfected().enableMustReachTarget();
    AnimationController tumorController = new AnimationController((IAnimatable)this, "tumor_controller", 0.0f, this::tumorPredicate);
    AnimationController mouthController = new AnimationController((IAnimatable)this, "mouth_controller", 0.0f, this::mouthPredicate);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SculkRavagerEntity(EntityType<? extends SculkRavagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public SculkRavagerEntity(World worldIn) {
        super(EntityRegistry.SCULK_RAVAGER, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233826_i_, 4.0).func_233815_a_(Attributes.field_233823_f_, 18.0).func_233815_a_(Attributes.field_233824_g_, 5.0).func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, (double)0.4f).func_233815_a_(Attributes.field_233820_c_, 0.75);
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    @Override
    public boolean isIdle() {
        return this.func_70638_az() == null;
    }

    public void func_184651_r() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.field_70714_bg.func_75776_a(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.field_70715_bh.func_75776_a(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        return new Goal[]{new DespawnWhenIdle(this, 120), new SwimGoal((MobEntity)this), new AttackGoal(), new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4)};
    }

    public Goal[] targetSelectorPayload() {
        return new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((CreatureEntity)this, new Class[0]).setAlertAllies(new Class[0]), new NearestLivingEntityTargetGoal((MobEntity)this, true, true)};
    }

    public void onRemovedFromWorld() {
        SculkHorde.gravemind.getGravemindMemory().addSculkAccumulatedMass((int)this.func_110143_aJ());
        super.onRemovedFromWorld();
    }

    protected int func_70693_a(PlayerEntity player) {
        return 3;
    }

    private <E extends IAnimatable> PlayState tumorPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ravager.tumors_idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState mouthPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ravager.mouth_idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(this.tumorController);
        data.addAnimationController(this.mouthController);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)SculkRavagerEntity.this, 1.0, true);
        }

        public boolean func_75250_a() {
            boolean canWeUse = ((ISculkSmartEntity)this.field_75441_b).getTargetParameters().isEntityValidTarget(this.field_75441_b.func_70638_az(), true);
            return canWeUse;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        protected double func_179512_a(LivingEntity pAttackTarget) {
            float f = SculkRavagerEntity.this.func_213311_cf() - 0.1f;
            return f * 2.0f * f * 2.0f + pAttackTarget.func_213311_cf();
        }
    }
}

