/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.SculkLivingEntity;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ParticleRegistry;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SculkSporeSpewerEntity
extends SculkLivingEntity
implements IAnimatable,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 40.0f;
    public static final float ARMOR = 10.0f;
    public static final float ATTACK_DAMAGE = 0.0f;
    public static final float ATTACK_KNOCKBACK = 0.0f;
    public static final float FOLLOW_RANGE = 0.0f;
    public static final float MOVEMENT_SPEED = 0.0f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((MobEntity)this).enableTargetPassives();
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private CursorSurfaceInfectorEntity cursor;
    private long INFECTION_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private long lastInfectionTime = 0L;

    public SculkSporeSpewerEntity(EntityType<? extends SculkSporeSpewerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public SculkSporeSpewerEntity(World worldIn) {
        super(EntityRegistry.SCULK_SPORE_SPEWER, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233824_g_, 0.0).func_233815_a_(Attributes.field_233819_b_, 0.0).func_233815_a_(Attributes.field_233821_d_, 0.0);
    }

    @Override
    public boolean isIdle() {
        return false;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public void func_184651_r() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.field_70714_bg.func_75776_a(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.field_70715_bh.func_75776_a(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new dieAfterTimeGoal(this)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new TargetAttacker((CreatureEntity)this, new Class[0]).setAlertAllies(new Class[0])};
        return goals;
    }

    public void func_70623_bb() {
    }

    protected int func_70693_a(PlayerEntity player) {
        return 10;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sculk_spore_spewer.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            Random random = new Random();
            for (int i = 0; i < 1; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegistry.SCULK_CRUST_PARTICLE.get(), this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 1.7, this.func_213303_ch().field_72449_c, (random.nextDouble() - 0.5) * 10.0, (random.nextDouble() - 0.5) * 10.0, (random.nextDouble() - 0.5) * 10.0);
            }
            return;
        }
        Random random = new Random();
        if (!(random.nextInt(100) != 0 || this.cursor != null && this.cursor.func_70089_S())) {
            this.cursor = new CursorSurfaceInfectorEntity(this.field_70170_p);
            this.cursor.func_70107_b(this.func_233580_cy_().func_177958_n(), this.func_233580_cy_().func_177956_o() - 1, this.func_233580_cy_().func_177952_p());
            this.cursor.setMaxInfections(20);
            this.cursor.setMaxRange(100);
            this.field_70170_p.func_217376_c((Entity)this.cursor);
        }
        if (System.currentTimeMillis() - this.lastInfectionTime > this.INFECTION_INTERVAL_MILLIS) {
            this.lastInfectionTime = System.currentTimeMillis();
            ArrayList entities = (ArrayList)EntityAlgorithms.getLivingEntitiesInBoundingBox((ServerWorld)this.field_70170_p, this.func_174813_aQ().func_186662_g(10.0));
            for (LivingEntity entity : entities) {
                if (!(entity instanceof LivingEntity) || !this.getTargetParameters().isEntityValidTarget(entity, false)) continue;
                entity.func_195064_c(new EffectInstance((Effect)EffectRegistry.SCULK_INFECTION.get(), 500, 3));
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187535_aY;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_187590_ba;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187536_aZ;
    }

    protected void func_180429_a(BlockPos pPos, BlockState pBlock) {
        this.func_184185_a(SoundEvents.field_187592_bb, 0.15f, 1.0f);
    }

    private class dieAfterTimeGoal
    extends Goal {
        private final SculkSporeSpewerEntity entity;
        private int timeUntilDeath = 0;

        public dieAfterTimeGoal(SculkSporeSpewerEntity entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75249_e() {
            this.timeUntilDeath = 72000;
        }

        public void func_75246_d() {
            if (SculkSporeSpewerEntity.this.field_70170_p.func_201670_d()) {
                return;
            }
            --this.timeUntilDeath;
            if (this.timeUntilDeath <= 0) {
                this.entity.func_70106_y();
            }
        }
    }
}

