/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.attack;

import com.github.sculkhorde.common.entity.SculkLivingEntity;
import com.github.sculkhorde.common.entity.projectile.CustomItemProjectileEntity;
import com.github.sculkhorde.util.ProjectileHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class RangedAttack {
    public SculkLivingEntity thisMob;
    public double xOffSetModifier = 2.0;
    public double entityHeightFraction = 0.5;
    public double zOffSetModifier = 2.0;
    public float damage = 1.0f;
    public double accuracy = 0.95;

    public RangedAttack(SculkLivingEntity parentEntity) {
        this.thisMob = parentEntity;
    }

    public RangedAttack(SculkLivingEntity parentEntity, double xOffSetModifier, double entityHeightFraction, double zOffSetModifier, float damage) {
        this.thisMob = parentEntity;
        this.xOffSetModifier = xOffSetModifier;
        this.entityHeightFraction = entityHeightFraction;
        this.zOffSetModifier = zOffSetModifier;
        this.damage = damage;
    }

    public abstract CustomItemProjectileEntity getProjectile(World var1, LivingEntity var2, float var3);

    public RangedAttack setProjectileOriginOffset(double x, double entityHeightFraction, double z) {
        this.xOffSetModifier = x;
        this.entityHeightFraction = entityHeightFraction;
        this.zOffSetModifier = z;
        return this;
    }

    public RangedAttack setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public RangedAttack setAccuracy(double accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public double rollAccuracy(double directional) {
        return directional + (1.0 - this.accuracy) * directional * this.thisMob.func_70681_au().nextGaussian();
    }

    public void shoot() {
        LivingEntity targetEntity = this.thisMob.func_70638_az();
        CustomItemProjectileEntity projectile = this.getProjectile(this.thisMob.field_70170_p, (LivingEntity)this.thisMob, this.damage);
        double d0 = targetEntity.func_226277_ct_() - this.thisMob.func_226277_ct_();
        double d1 = targetEntity.func_226280_cw_() - projectile.func_226278_cu_();
        double d2 = targetEntity.func_226281_cx_() - this.thisMob.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 > 40.0) {
            return;
        }
        double velocity = 1.6;
        d1 = ProjectileHelper.computeY(d3, d1, velocity, projectile.func_226278_cu_(), targetEntity.func_226278_cu_(), targetEntity.func_226280_cw_() - targetEntity.func_226278_cu_());
        float inaccuracy = 0.0f;
        projectile.func_70186_c(d0, d1, d2, (float)velocity, inaccuracy);
        this.thisMob.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f);
        this.thisMob.field_70170_p.func_217376_c((Entity)projectile);
    }
}

