/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;

public class InvalidateTargetGoal
extends Goal {
    private final ISculkSmartEntity mob;
    private UUID lastTargetUUID;
    private long timeSinceLastTargetChange;
    private BlockPos ourLastPositionSinceCheck;
    private long UNREACHABLE_TARGET_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private long lastTimeSincePositionCheck = System.currentTimeMillis();
    private long POSITION_CHECK_INTERVAL = TimeUnit.SECONDS.toMillis(5L);

    public InvalidateTargetGoal(ISculkSmartEntity mob) {
        this.mob = mob;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public MobEntity getMob() {
        return (MobEntity)this.mob;
    }

    public LivingEntity getTarget() {
        return this.getMob().func_70638_az();
    }

    private boolean hasTargetChanged() {
        if (this.getTarget() == null) {
            return false;
        }
        if (this.lastTargetUUID == null || !this.lastTargetUUID.equals(this.getTarget().func_110124_au())) {
            this.lastTargetUUID = this.getTarget().func_110124_au();
            this.timeSinceLastTargetChange = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    private boolean tooCloseToLastPosition() {
        return BlockAlgorithms.getBlockDistance(this.ourLastPositionSinceCheck, this.getMob().func_233580_cy_()) < 5.0f;
    }

    public boolean func_75250_a() {
        if (this.getTarget() == null) {
            return false;
        }
        TargetParameters targetParameters = this.mob.getTargetParameters();
        if (System.currentTimeMillis() - this.lastTimeSincePositionCheck > this.POSITION_CHECK_INTERVAL) {
            this.ourLastPositionSinceCheck = this.getMob().func_233580_cy_();
            this.lastTimeSincePositionCheck = System.currentTimeMillis();
        }
        if (this.getTarget() instanceof MobEntity && !this.hasTargetChanged() && System.currentTimeMillis() - this.timeSinceLastTargetChange > this.UNREACHABLE_TARGET_TIMEOUT && this.tooCloseToLastPosition()) {
            targetParameters.addToBlackList((MobEntity)this.getTarget());
        }
        boolean result = !targetParameters.isEntityValidTarget(this.getTarget(), true);
        return result;
    }

    public void func_75249_e() {
        this.getMob().func_70624_b(null);
        this.getMob().func_70638_az();
    }

    public boolean func_75253_b() {
        return false;
    }
}

