/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.SculkLivingEntity;
import com.github.sculkhorde.common.entity.attack.RangedAttack;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;

public class RangedAttackGoal
extends Goal {
    private final SculkLivingEntity entity;
    private double moveSpeedAmp = 1.0;
    private int attackCooldown;
    private int visibleTicksDelay = 3;
    private float maxAttackDistance = 20.0f;
    private int strafeTicksThreshold = 20;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int statecheck;
    private RangedAttack attack;
    private boolean multiShot = false;
    private int multiShotCount = 0;
    private int multiShotTickDelay = 0;
    private boolean multiShooting = false;
    private int multiShotsLeft = 0;
    private int multiShotTicker = 0;

    public RangedAttackGoal(SculkLivingEntity mob, RangedAttack attack, double moveSpeedAmpIn, int attackCooldownIn, int visibleTicksDelay, int strafeTicksThreshold, float maxAttackDistanceIn, int state2) {
        this.entity = mob;
        this.moveSpeedAmp = moveSpeedAmpIn;
        this.attackCooldown = attackCooldownIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attack = attack;
        this.visibleTicksDelay = visibleTicksDelay;
        this.strafeTicksThreshold = strafeTicksThreshold;
        this.statecheck = state2;
    }

    public RangedAttackGoal(SculkLivingEntity mob, RangedAttack attack, int attackCooldownIn) {
        this.entity = mob;
        this.attackCooldown = attackCooldownIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attack = attack;
    }

    public RangedAttackGoal setMultiShot(int count, int tickDelay) {
        this.multiShot = true;
        this.multiShotCount = count;
        this.multiShotTickDelay = tickDelay;
        return this;
    }

    public boolean tickMultiShot() {
        if (this.multiShotsLeft > 0 && this.multiShotTicker == 0) {
            --this.multiShotsLeft;
            if (this.multiShotsLeft == 0) {
                this.finishMultiShot();
            }
            this.multiShotTicker = this.multiShotTickDelay;
            return true;
        }
        --this.multiShotTicker;
        return false;
    }

    public void beginMultiShooting() {
        this.multiShooting = true;
        this.multiShotsLeft = this.multiShotCount - 1;
        this.multiShotTicker = this.multiShotTickDelay;
    }

    public void finishMultiShot() {
        this.multiShooting = false;
        this.multiShotsLeft = 0;
    }

    public void setAttackCooldown(int attackCooldownIn) {
        this.attackCooldown = attackCooldownIn;
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null && !this.entity.func_70638_az().func_233643_dh_();
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.entity.func_213395_q(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.func_213395_q(false);
        this.entity.setAttackingState(0);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
    }

    public void func_75246_d() {
        if (!this.func_75250_a()) {
            return;
        }
        LivingEntity targetEntity = this.entity.func_70638_az();
        double distanceToTargetSq = this.entity.func_70092_e(targetEntity.func_226277_ct_(), targetEntity.func_226278_cu_(), targetEntity.func_226281_cx_());
        boolean inLineOfSight = this.entity.func_70635_at().func_75522_a((Entity)targetEntity);
        if (inLineOfSight != this.seeTime > 0) {
            this.seeTime = 0;
        }
        if (inLineOfSight) {
            ++this.seeTime;
        } else {
            if (this.multiShot) {
                this.finishMultiShot();
            }
            --this.seeTime;
        }
        if (distanceToTargetSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.entity.func_70661_as().func_75499_g();
            ++this.strafingTime;
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)targetEntity, this.moveSpeedAmp);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= this.strafeTicksThreshold) {
            if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (distanceToTargetSq > (double)(this.maxAttackDistance * 0.75f)) {
                this.strafingBackwards = false;
            } else if (distanceToTargetSq < (double)(this.maxAttackDistance * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.entity.func_70625_a((Entity)targetEntity, 30.0f, 30.0f);
        } else {
            this.entity.func_70671_ap().func_75651_a((Entity)targetEntity, 30.0f, 30.0f);
        }
        if (this.multiShooting) {
            if (this.tickMultiShot()) {
                this.attack.shoot();
            }
            return;
        }
        if (this.seeTime >= this.visibleTicksDelay) {
            if (this.attackTime >= this.attackCooldown) {
                this.attack.shoot();
                this.attackTime = 0;
            } else {
                ++this.attackTime;
            }
        }
        this.entity.setAttackingState((double)this.attackTime >= (double)this.attackCooldown * 0.75 ? this.statecheck : 0);
    }
}

