/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.SculkLivingEntity;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;

public class TargetAttacker
extends TargetGoal {
    private static final EntityPredicate HURT_BY_TARGETING = new EntityPredicate().func_221014_c().func_221010_e();
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    private Class<?>[] toIgnoreAlert;

    public TargetAttacker(CreatureEntity sourceEntity, Class<?> ... p_i50317_2_) {
        super((MobEntity)sourceEntity, true);
        this.toIgnoreDamage = p_i50317_2_;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public TargetAttacker setAlertAllies(Class<?> ... pReinforcementTypes) {
        this.alertSameType = true;
        this.toIgnoreAlert = pReinforcementTypes;
        return this;
    }

    public boolean func_75250_a() {
        int i = this.field_75299_d.func_142015_aE();
        LivingEntity livingentity = this.field_75299_d.func_70643_av();
        if (EntityAlgorithms.isSculkLivingEntity.test(livingentity)) {
            return false;
        }
        if (i != this.timestamp && livingentity != null) {
            if (livingentity.func_200600_R() == EntityType.field_200729_aH && this.field_75299_d.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                return false;
            }
            for (Class<?> oclass : this.toIgnoreDamage) {
                if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                return false;
            }
            return this.func_220777_a(livingentity, HURT_BY_TARGETING);
        }
        return false;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.field_75299_d.func_70643_av());
        this.field_188509_g = this.field_75299_d.func_70638_az();
        this.timestamp = this.field_75299_d.func_142015_aE();
        this.field_188510_h = 60;
        if (!EntityAlgorithms.isSculkLivingEntity.test(this.field_75299_d.func_70643_av()) && this.field_75299_d.func_70643_av() != null) {
            SculkHorde.gravemind.getGravemindMemory().addHostileToMemory(this.field_75299_d.func_70643_av(), (ServerWorld)this.field_75299_d.field_70170_p);
        }
        if (this.alertSameType) {
            this.alertSculkLivingEntities();
        }
        super.func_75249_e();
    }

    protected void alertSculkLivingEntities() {
        boolean DEBUG_THIS = false;
        double d0 = this.func_111175_f();
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)this.field_75299_d.func_213303_ch()).func_72314_b(d0, 10.0, d0);
        List list = this.field_75299_d.field_70170_p.func_225317_b(SculkLivingEntity.class, axisalignedbb);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MobEntity mobentity = (MobEntity)iterator.next();
            boolean isAlertingSelf = this.field_75299_d == mobentity;
            boolean hasTargetAlready = mobentity.func_70638_az() != null;
            boolean isProtector = EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)mobentity);
            if (DEBUG_THIS) {
                System.out.println("Attempting to Call Protectors");
                System.out.println("[ isAlertingSelf? = " + isAlertingSelf + " hasTargetAlready? =" + hasTargetAlready + " isProtector? =" + isProtector + "]");
            }
            if (isAlertingSelf || hasTargetAlready || !isProtector) continue;
            this.alertOther(mobentity, this.field_75299_d.func_70643_av());
        }
        return;
    }

    protected void alertOther(MobEntity pMob, LivingEntity pTarget) {
        pMob.func_70624_b(pTarget);
    }
}

