/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.block.SculkLivingRockBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CursorBridgerEntity
extends Entity {
    private int MAX_DISTANCE = 1000;
    private int distanceTraveled = 0;
    private Direction direction = Direction.DOWN;
    private long MAX_LIFETIME_SECONDS = 10L;
    private long creationTickTime = System.nanoTime();
    private long lastTickTime = 0L;
    private long TICK_INVTERVAL_SECONDS = 5L;
    public BlockPos lastKnownBlockPos = BlockPos.field_177992_a;
    public boolean isSuccessful = false;

    public CursorBridgerEntity(World worldIn) {
        super(EntityRegistry.CURSOR_LONG_RANGE, worldIn);
    }

    public CursorBridgerEntity(EntityType<?> pType, World pLevel) {
        super(pType, pLevel);
        this.distanceTraveled = 0;
        this.creationTickTime = System.nanoTime();
    }

    public void setMAX_DISTANCE(int MAX_DISTANCE) {
        this.MAX_DISTANCE = MAX_DISTANCE;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTickTime, TimeUnit.NANOSECONDS);
        if (timeElapsed < (float)this.TICK_INVTERVAL_SECONDS) {
            // empty if block
        }
        this.lastTickTime = System.nanoTime();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            return;
        }
        long currentLifeTime = TimeUnit.SECONDS.convert(System.nanoTime() - this.creationTickTime, TimeUnit.NANOSECONDS);
        if (currentLifeTime >= this.MAX_LIFETIME_SECONDS || this.distanceTraveled >= this.MAX_DISTANCE) {
            this.func_70106_y();
            return;
        }
        ArrayList<BlockPos> neighbors = BlockAlgorithms.getAdjacentNeighbors(this.func_233580_cy_());
        BlockPos closest = neighbors.get(0);
        for (BlockPos pos : neighbors) {
            closest = pos;
            if (!this.field_70170_p.func_180495_p(closest).func_196958_f()) continue;
            this.field_70170_p.func_175656_a(closest, ((SculkLivingRockBlock)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()).func_176223_P());
        }
        this.func_70107_b(closest.func_177958_n(), closest.func_177956_o(), closest.func_177952_p());
        this.lastKnownBlockPos = this.func_233580_cy_();
        if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_185887_b((IBlockReader)this.field_70170_p, this.func_233580_cy_()) <= 3.0f) {
            this.field_70170_p.func_175656_a(this.func_233580_cy_(), ((SculkLivingRockBlock)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()).func_176223_P());
        }
        ++this.distanceTraveled;
    }

    protected void func_70037_a(CompoundNBT pCompound) {
    }

    protected void func_213281_b(CompoundNBT pCompound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

