/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ParticleRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class CursorInfectorEntity
extends Entity {
    State state = State.IDLE;
    protected int MAX_INFECTIONS = 100;
    protected int infections = 0;
    protected int MAX_RANGE = 20;
    protected long MAX_LIFETIME_MILLIS = TimeUnit.MINUTES.toMillis(20L);
    protected long creationTickTime = System.currentTimeMillis();
    protected long lastTickTime = 0L;
    protected int searchIterationsPerTick = 20;
    protected long tickIntervalMilliseconds = 1000L;
    protected BlockPos origin = BlockPos.field_177992_a;
    protected BlockPos target = BlockPos.field_177992_a;
    Queue<BlockPos> queue = new LinkedList<BlockPos>();
    Set<BlockPos> visited = new HashSet<BlockPos>();
    public boolean isSuccessful = false;
    protected HashMap<Long, Boolean> visitedPositons = new HashMap();

    public CursorInfectorEntity(World worldIn) {
        super(EntityRegistry.CURSOR_SHORT_RANGE, worldIn);
    }

    public CursorInfectorEntity(EntityType<?> pType, World pLevel) {
        super(pType, pLevel);
        this.creationTickTime = System.currentTimeMillis();
    }

    public void setMaxInfections(int MAX_INFECTIONS) {
        this.MAX_INFECTIONS = MAX_INFECTIONS;
    }

    public void setMaxRange(int MAX_RANGE) {
        this.MAX_RANGE = MAX_RANGE;
    }

    public void setMaxLifeTimeMillis(long MAX_LIFETIME) {
        this.MAX_LIFETIME_MILLIS = MAX_LIFETIME;
    }

    public void setSearchIterationsPerTick(int iterations) {
        this.searchIterationsPerTick = iterations;
    }

    public void setTickIntervalMilliseconds(long milliseconds) {
        this.tickIntervalMilliseconds = milliseconds;
    }

    protected void func_70088_a() {
    }

    protected boolean searchTick() {
        for (int i = 0; i < this.searchIterationsPerTick; ++i) {
            if (this.queue.isEmpty()) {
                this.isSuccessful = false;
                this.target = BlockPos.field_177992_a;
                return true;
            }
            BlockPos currentBlock = this.queue.poll();
            if (this.isTarget(this.field_70170_p.func_180495_p(currentBlock), currentBlock)) {
                this.isSuccessful = true;
                this.target = currentBlock;
                return true;
            }
            ArrayList<Direction> possibleDirections = new ArrayList<Direction>();
            for (Direction dir : Direction.values()) {
                if (this.isObstructed(this.field_70170_p.func_180495_p(currentBlock.func_177972_a(dir)), currentBlock.func_177972_a(dir))) continue;
                possibleDirections.add(dir);
            }
            Collections.shuffle(possibleDirections);
            for (Direction dir : possibleDirections) {
                BlockPos neighbor = currentBlock.func_177972_a(dir);
                if (this.visited.contains(neighbor)) continue;
                this.queue.add(neighbor);
                this.visited.add(neighbor);
            }
        }
        return false;
    }

    public void func_70071_h_() {
        long currentLifeTimeMilliseconds;
        super.func_70071_h_();
        float timeElapsedMilliSeconds = System.currentTimeMillis() - this.lastTickTime;
        if (timeElapsedMilliSeconds < (float)this.tickIntervalMilliseconds) {
            return;
        }
        this.lastTickTime = System.currentTimeMillis();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleEffects();
            }
            return;
        }
        if (this.origin == BlockPos.field_177992_a) {
            this.origin = this.func_233580_cy_();
        }
        if ((currentLifeTimeMilliseconds = System.currentTimeMillis() - this.creationTickTime) >= this.MAX_LIFETIME_MILLIS) {
            this.state = State.FINISHED;
        } else if (this.infections >= this.MAX_INFECTIONS) {
            this.state = State.FINISHED;
        }
        if (this.state == State.IDLE) {
            this.queue.add(this.func_233580_cy_());
            this.state = State.SEARCHING;
        } else if (this.state == State.SEARCHING) {
            if (!this.searchTick()) {
                return;
            }
            this.state = this.target.equals((Object)BlockPos.field_177992_a) ? State.FINISHED : State.EXPLORING;
        } else if (this.state == State.EXPLORING) {
            ArrayList<BlockPos> neighbors = BlockAlgorithms.getNeighborsCube(this.func_233580_cy_());
            ArrayList<BlockPos> unobstructedNeighbors = new ArrayList<BlockPos>();
            for (BlockPos neighbor : neighbors) {
                if (this.isObstructed(this.field_70170_p.func_180495_p(neighbor), neighbor)) continue;
                unobstructedNeighbors.add(neighbor);
            }
            if (neighbors.size() == 0) {
                return;
            }
            BlockPos closest = neighbors.get(0);
            for (BlockPos pos : neighbors) {
                if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
                closest = pos;
            }
            this.func_70107_b(closest.func_177958_n(), closest.func_177956_o(), closest.func_177952_p());
            this.visitedPositons.put(closest.func_218275_a(), true);
            if (this.func_233580_cy_().equals((Object)this.target)) {
                this.target = BlockPos.field_177992_a;
                this.transformBlock(this.func_233580_cy_());
                ++this.infections;
                this.state = State.SEARCHING;
                this.visited.clear();
                this.queue.clear();
                this.queue.add(this.func_233580_cy_());
            }
        } else if (this.state == State.FINISHED) {
            this.func_70106_y();
        }
    }

    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (!state2.func_200015_d((IBlockReader)this.field_70170_p, pos)) {
            return true;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.func_196958_f()) {
            return true;
        }
        return this.visitedPositons.containsKey(pos.func_218275_a());
    }

    protected boolean isTarget(BlockState state2, BlockPos pos) {
        return SculkHorde.infestationConversionTable.infestationTable.isNormalVariant(state2);
    }

    protected void transformBlock(BlockPos pos) {
        SculkHorde.infestationConversionTable.infectBlock((ServerWorld)this.field_70170_p, pos);
    }

    protected void spawnParticleEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleRegistry.SCULK_CRUST_PARTICLE.get(), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
    }

    protected void func_70037_a(CompoundNBT pCompound) {
    }

    protected void func_213281_b(CompoundNBT pCompound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setTarget(BlockPos target) {
        this.target = target;
    }

    static enum State {
        IDLE,
        SEARCHING,
        EXPLORING,
        FINISHED;

    }
}

