/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.block.SculkLivingRockBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ParticleRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class CursorProberEntity
extends Entity {
    private int MAX_DISTANCE = 1000;
    private int distanceTraveled = 0;
    private BlockPos target = BlockPos.field_177992_a;
    private Direction direction = Direction.DOWN;
    private long MAX_LIFETIME_SECONDS = 10L;
    private long creationTickTime = System.nanoTime();
    private long lastTickTime = 0L;
    private long TICK_INVTERVAL_SECONDS = 5L;
    public BlockPos lastKnownBlockPos = BlockPos.field_177992_a;
    public boolean isSuccessful = false;

    public CursorProberEntity(World worldIn) {
        super(EntityRegistry.CURSOR_LONG_RANGE, worldIn);
    }

    public CursorProberEntity(EntityType<?> pType, World pLevel) {
        super(pType, pLevel);
        this.distanceTraveled = 0;
        this.creationTickTime = System.nanoTime();
    }

    public void setMAX_DISTANCE(int MAX_DISTANCE) {
        this.MAX_DISTANCE = MAX_DISTANCE;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    protected void func_70088_a() {
    }

    private BlockPos findNearestTargetBlockDepthFirstSearch(Direction direction) {
        BlockPos origin = this.func_233580_cy_();
        int nodesVisited = 0;
        Stack<BlockPos> stack = new Stack<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.push(origin);
        visited.add(origin);
        while (!stack.isEmpty()) {
            BlockPos currentBlock = (BlockPos)stack.pop();
            ++nodesVisited;
            if (SculkHorde.infestationConversionTable.infestationTable.isNormalVariant(this.field_70170_p.func_180495_p(currentBlock))) {
                return currentBlock;
            }
            if (BlockAlgorithms.getBlockDistance(currentBlock, origin) > (float)this.MAX_DISTANCE) break;
            ArrayList<Direction> possibleDirections = new ArrayList<Direction>();
            if (Math.random() < 0.25 && this.field_70170_p.func_180495_p(currentBlock.func_177972_a(direction)).func_200015_d((IBlockReader)this.field_70170_p, currentBlock.func_177972_a(direction))) {
                possibleDirections.add(direction);
            } else {
                possibleDirections.addAll(Arrays.asList(Direction.values()));
                possibleDirections.removeIf(dir -> !this.field_70170_p.func_180495_p(currentBlock.func_177972_a(dir)).func_200015_d((IBlockReader)this.field_70170_p, currentBlock.func_177972_a(dir)));
            }
            for (Direction dir2 : possibleDirections) {
                BlockPos neighbor = currentBlock.func_177972_a(dir2);
                if (visited.contains(neighbor)) continue;
                stack.push(neighbor);
                visited.add(neighbor);
            }
        }
        this.func_70106_y();
        this.isSuccessful = false;
        return BlockPos.field_177992_a;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTickTime, TimeUnit.NANOSECONDS);
        if (timeElapsed < (float)this.TICK_INVTERVAL_SECONDS) {
            // empty if block
        }
        this.lastTickTime = System.nanoTime();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegistry.SCULK_CRUST_PARTICLE.get(), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            return;
        }
        long currentLifeTime = TimeUnit.SECONDS.convert(System.nanoTime() - this.creationTickTime, TimeUnit.NANOSECONDS);
        if (currentLifeTime >= this.MAX_LIFETIME_SECONDS || this.distanceTraveled >= this.MAX_DISTANCE) {
            this.func_70106_y();
            return;
        }
        if (this.target.equals((Object)BlockPos.field_177992_a)) {
            this.target = this.findNearestTargetBlockDepthFirstSearch(this.direction);
        }
        ArrayList<BlockPos> neighbors = BlockAlgorithms.getAdjacentNeighbors(this.func_233580_cy_());
        BlockPos closest = neighbors.get(0);
        for (BlockPos pos : neighbors) {
            if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
            closest = pos;
        }
        if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_196958_f()) {
            this.field_70170_p.func_175656_a(this.func_233580_cy_(), ((SculkLivingRockBlock)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()).func_176223_P());
        }
        if (this.target.equals((Object)BlockPos.field_177992_a)) {
            this.isSuccessful = false;
            return;
        }
        this.func_70107_b(closest.func_177958_n(), closest.func_177956_o(), closest.func_177952_p());
        this.lastKnownBlockPos = this.func_233580_cy_();
        SculkHorde.infestationConversionTable.infectBlock((ServerWorld)this.field_70170_p, this.func_233580_cy_());
        ++this.distanceTraveled;
        if (this.func_233580_cy_().equals((Object)this.target)) {
            this.isSuccessful = true;
            this.func_70106_y();
        }
    }

    protected void func_70037_a(CompoundNBT pCompound) {
    }

    protected void func_213281_b(CompoundNBT pCompound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setTarget(BlockPos target) {
        this.target = target;
    }
}

