/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CursorSurfacePurifierEntity
extends CursorSurfaceInfectorEntity {
    public static Predicate<BlockState> isSculkFlora = b -> {
        if (b.func_203425_a((Block)BlockRegistry.GRASS.get())) {
            return true;
        }
        if (b.func_203425_a((Block)BlockRegistry.GRASS_SHORT.get())) {
            return true;
        }
        if (b.func_203425_a((Block)BlockRegistry.SMALL_SHROOM.get())) {
            return true;
        }
        if (b.func_203425_a((Block)BlockRegistry.SCULK_SHROOM_CULTURE.get())) {
            return true;
        }
        if (b.func_203425_a((Block)BlockRegistry.SPIKE.get())) {
            return true;
        }
        return b.func_203425_a((Block)BlockRegistry.SCULK_SUMMONER_BLOCK.get());
    };

    public CursorSurfacePurifierEntity(World worldIn) {
        super(EntityRegistry.CURSOR_SURFACE_PURIFIER, worldIn);
    }

    public CursorSurfacePurifierEntity(EntityType<?> pType, World pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isTarget(BlockState state2, BlockPos pos) {
        return SculkHorde.infestationConversionTable.infestationTable.isInfectedVariant(state2);
    }

    @Override
    protected void transformBlock(BlockPos pos) {
        SculkHorde.infestationConversionTable.deinfectBlock((ServerWorld)this.field_70170_p, pos);
        if (isSculkFlora.test(this.field_70170_p.func_180495_p(pos.func_177984_a()))) {
            this.field_70170_p.func_175656_a(pos.func_177984_a(), Blocks.field_150349_c.func_176223_P());
        }
    }

    @Override
    protected void spawnParticleEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218420_D, this.func_226282_d_(1.5), this.func_226279_cv_(), this.func_226287_g_(1.5), 0.0, 0.0, 0.0);
    }

    @Override
    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (!state2.func_200015_d((IBlockReader)this.field_70170_p, pos)) {
            return true;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.func_196958_f()) {
            return true;
        }
        if (this.visitedPositons.containsKey(pos.func_218275_a())) {
            return true;
        }
        return !BlockAlgorithms.isExposedToAir((ServerWorld)this.field_70170_p, pos);
    }
}

