/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorInfectorEntity;
import com.github.sculkhorde.common.entity.infection.CursorProberEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class InfectionTree {
    private TreeNode root;
    private boolean Active = false;
    private final Direction direction;
    private CursorProberEntity cursorProbe;
    private CursorInfectorEntity cursorInfection;
    private final ServerWorld world;
    private state currentState = state.IDLE;
    private BlockPos potentialNodePosition = null;
    private int failedProbeAttempts = 0;
    private final int MAX_FAILED_PROBE_ATTEMPTS = 10;
    private int currentProbeRange = 10;
    private final int MAX_PROBE_RANGE = 5000;
    private final int MIN_PROBE_RANGE = 10;
    private final int PROBE_RANGE_INCREMENT = 50;
    private int currentInfectRange = 10;
    private final int MAX_INFECTOR_RANGE = 50;
    private final int MIN_INFECTOR_RANGE = 10;
    private final int MAX_INFECTOR_RANGE_INCREMENT = 10;
    private BlockPos infectedTargetPosition = null;
    private int failedInfectionAttempts = 0;
    private final int MAX_FAILED_INFECTION_ATTEMPTS = 10;

    public InfectionTree(ServerWorld world, Direction direction, BlockPos rootPos) {
        this.root = new TreeNode(rootPos);
        this.direction = direction;
        this.world = world;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void activate() {
        this.Active = true;
    }

    public void deactivate() {
        this.Active = false;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public void createProbeCursor(int maxDistance) {
        this.cursorProbe = new CursorProberEntity((World)this.world);
        this.cursorProbe.setMAX_DISTANCE(maxDistance);
        this.cursorProbe.setDirection(this.direction);
        this.cursorProbe.func_70107_b(this.root.blockPos.func_177958_n(), this.root.blockPos.func_177956_o(), this.root.blockPos.func_177952_p());
        this.world.func_217376_c((Entity)this.cursorProbe);
    }

    public void createInfectionCursor(int maxInfections) {
        this.cursorInfection = new CursorInfectorEntity((World)this.world);
        this.cursorInfection.func_70107_b(this.infectedTargetPosition.func_177958_n(), this.infectedTargetPosition.func_177956_o(), this.infectedTargetPosition.func_177952_p());
        this.cursorInfection.setMaxInfections(maxInfections);
        this.cursorInfection.setMaxRange(maxInfections);
        this.world.func_217376_c((Entity)this.cursorInfection);
    }

    public void tick() {
        if (this.root.blockPos == BlockPos.field_177992_a || !this.isActive()) {
            return;
        }
        if (this.failedProbeAttempts >= 10) {
            this.currentState = state.COMPLETE;
        }
        if (this.currentProbeRange > 5000) {
            this.currentProbeRange = 10;
        }
        if (this.currentState == state.IDLE) {
            this.currentState = state.PROBING;
        } else if (this.currentState == state.PROBING) {
            if (this.cursorProbe == null) {
                this.createProbeCursor(this.currentProbeRange);
                return;
            }
            if (this.cursorProbe.func_70089_S()) {
                return;
            }
            if (this.cursorProbe.isSuccessful) {
                this.potentialNodePosition = this.cursorProbe.lastKnownBlockPos;
                this.failedProbeAttempts = 0;
                this.cursorProbe = null;
                this.currentState = state.INFECTION;
            } else {
                this.cursorProbe = null;
                ++this.failedProbeAttempts;
                this.potentialNodePosition = BlockPos.field_177992_a;
            }
        } else if (this.currentState == state.INFECTION) {
            this.infectedTargetPosition = this.potentialNodePosition;
            if (this.cursorInfection == null) {
                this.createInfectionCursor(this.currentInfectRange);
                return;
            }
            if (this.cursorInfection.func_70089_S()) {
                return;
            }
            if (this.cursorInfection.isSuccessful) {
                this.failedInfectionAttempts = 0;
                this.cursorInfection = null;
            } else {
                ++this.failedInfectionAttempts;
                this.cursorInfection = null;
            }
            if (this.failedInfectionAttempts >= 10) {
                this.currentInfectRange += 10;
                this.failedInfectionAttempts = 0;
            }
            if (this.currentInfectRange > 50) {
                this.failedInfectionAttempts = 0;
                this.currentInfectRange = 10;
                this.currentState = state.PROBING;
            }
        } else if (this.currentState == state.COMPLETE) {
            if (this.failedProbeAttempts >= 10) {
                this.currentProbeRange += 50;
                this.failedProbeAttempts = 0;
                this.currentState = state.IDLE;
            }
            if (this.failedInfectionAttempts >= 10) {
                this.currentState = state.IDLE;
                this.failedInfectionAttempts = 0;
            }
        }
    }

    public class TreeNode {
        private BlockPos blockPos;
        private TreeNode left;
        private TreeNode right;

        public TreeNode(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public Object getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public TreeNode getLeft() {
            return this.left;
        }

        public void setLeft(TreeNode left) {
            this.left = left;
        }

        public TreeNode getRight() {
            return this.right;
        }

        public void setRight(TreeNode right) {
            this.right = right;
        }
    }

    private static enum state {
        IDLE,
        PROBING,
        INFECTION,
        COMPLETE;

    }
}

