/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.projectile;

import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ItemRegistry;
import com.github.sculkhorde.util.EntityAlgorithms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;

public class CustomItemProjectileEntity
extends ProjectileItemEntity {
    private float damage = 50.0f;

    public CustomItemProjectileEntity(EntityType<? extends CustomItemProjectileEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public CustomItemProjectileEntity(World worldIn, LivingEntity shooterIn, float damageIn) {
        this(EntityRegistry.CUSTOM_ITEM_PROJECTILE_ENTITY, worldIn);
        this.func_70107_b(shooterIn.func_226277_ct_(), shooterIn.func_226280_cw_(), shooterIn.func_226281_cx_());
        this.func_212361_a((Entity)shooterIn);
        this.setDamage(damageIn);
    }

    public CustomItemProjectileEntity setDamage(float damageIn) {
        this.damage = damageIn;
        return this;
    }

    protected Item func_213885_i() {
        return (Item)ItemRegistry.CUSTOM_ITEM_PROJECTILE.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    private IParticleData getParticle() {
        ItemStack itemstack = this.func_213882_k();
        return itemstack.func_190926_b() ? ParticleTypes.field_205167_W : new ItemParticleData(ParticleTypes.field_197591_B, itemstack);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        Entity entity = this.func_234616_v_();
        if (entity instanceof PlayerEntity && !entity.func_70089_S()) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
        }
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        super.func_213868_a(raytrace);
        if (!(raytrace.func_216348_a() instanceof LivingEntity)) {
            return;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)raytrace.func_216348_a()) || this.func_234616_v_() == this.getEntity()) {
            return;
        }
        raytrace.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), this.damage);
        this.func_184185_a(SoundEvents.field_226135_eP_, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (raytrace.func_216348_a() instanceof LivingEntity) {
            ((LivingEntity)raytrace.func_216348_a()).func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1));
        }
        this.func_70106_y();
    }

    protected void func_230299_a_(BlockRayTraceResult raytrace) {
        super.func_230299_a_(raytrace);
        if (!(!(this.field_70146_Z.nextFloat() < 0.028f) || this.func_234616_v_() instanceof PlayerEntity && ((PlayerEntity)this.func_234616_v_()).func_184812_l_())) {
            Vector3d vec = raytrace.func_216347_e();
            ItemEntity item = new ItemEntity(this.field_70170_p, vec.field_72450_a, vec.field_72448_b + 0.25, vec.field_72449_c, new ItemStack((IItemProvider)this.func_213885_i()));
            this.field_70170_p.func_217376_c((Entity)item);
        } else {
            this.func_184185_a(SoundEvents.field_226135_eP_, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        this.func_70106_y();
    }

    public Entity changeDimension(ServerWorld serverWorld, ITeleporter iTeleporter) {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.field_70170_p.func_234923_W_() != serverWorld.func_234923_W_()) {
            this.func_212361_a(null);
        }
        return super.changeDimension(serverWorld, iTeleporter);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte pId) {
        if (pId == 3) {
            IParticleData iparticledata = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a(iparticledata, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

