/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class Line3D {
    private Vector3d start;
    private Vector3d end;
    private Vector3d direction;

    public Line3D(Vector3d start, Vector3d end) {
        this.start = start;
        this.end = end;
        this.direction = end.func_178788_d(start);
    }

    public Line3D(BlockPos start, BlockPos end) {
        this(new Vector3d((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p()), new Vector3d((double)end.func_177958_n(), (double)end.func_177956_o(), (double)end.func_177952_p()));
    }

    public double getLength() {
        return this.direction.func_72433_c();
    }

    public void iterateOverLine(double stepSize, Consumer<Vector3d> consumer) {
        double length = this.getLength();
        for (double offset = 0.0; offset < length; offset += stepSize) {
            Vector3d point = this.start.func_178787_e(this.direction.func_72432_b().func_186678_a(offset));
            consumer.accept(point);
        }
    }

    public ArrayList<BlockPos> getBlockPositionsOnLineWithSphere(double radius) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        this.iterateOverLine(1.0, point -> {
            int x = MathHelper.func_76128_c((double)point.field_72450_a);
            int y = MathHelper.func_76128_c((double)point.field_72448_b);
            int z = MathHelper.func_76128_c((double)point.field_72449_c);
            for (int i = -MathHelper.func_76128_c((double)radius); i <= MathHelper.func_76128_c((double)radius); ++i) {
                for (int j = -MathHelper.func_76128_c((double)radius); j <= MathHelper.func_76128_c((double)radius); ++j) {
                    for (int k = -MathHelper.func_76128_c((double)radius); k <= MathHelper.func_76128_c((double)radius); ++k) {
                        double distanceSq = i * i + j * j + k * k;
                        if (!(distanceSq <= radius * radius)) continue;
                        blockPosList.add(new BlockPos(x + i, y + j, z + k));
                    }
                }
            }
        });
        return blockPosList;
    }
}

