/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.core.SculkHorde;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class PlannedBlock {
    protected BlockState plannedBlock = null;
    protected BlockPos targetPos;
    protected ServerWorld world;
    protected final Predicate<BlockState> VALID_BLOCKS_TO_REPLACE = validBlocksPredicate -> SculkHorde.infestationConversionTable.infestationTable.isNormalVariant((BlockState)validBlocksPredicate) || validBlocksPredicate.func_227032_a_((Fluid)Fluids.field_204546_a) || SculkHorde.infestationConversionTable.infestationTable.isInfectedVariant((BlockState)validBlocksPredicate) || validBlocksPredicate.func_185887_b((IBlockReader)this.world, this.targetPos) <= 3.0f || validBlocksPredicate.func_177230_c().isAir(validBlocksPredicate, (IBlockReader)this.world, this.targetPos);

    public PlannedBlock(ServerWorld worldIn, BlockState plannedBlockIn, BlockPos targetPosIn) {
        this.plannedBlock = plannedBlockIn;
        this.targetPos = targetPosIn;
        this.world = worldIn;
    }

    public boolean canBePlaced() {
        return this.VALID_BLOCKS_TO_REPLACE.test(this.world.func_180495_p(this.targetPos));
    }

    public boolean isPlaced() {
        return this.world.func_180495_p(this.targetPos).func_203425_a(this.plannedBlock.func_177230_c());
    }

    public void build() {
        if (this.canBePlaced()) {
            this.world.func_175656_a(this.targetPos, this.plannedBlock);
        }
    }

    public BlockPos getPosition() {
        return this.targetPos;
    }
}

