/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.block.SculkBeeNestCellBlock;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SculkBeeNestProceduralStructure
extends ProceduralStructure {
    public SculkBeeNestProceduralStructure(ServerWorld worldIn, BlockPos originIn) {
        super(worldIn, originIn);
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        for (ProceduralStructure entry : this.childStructuresQueue) {
            entry.generatePlan();
        }
        for (int offset = 1; offset <= 4; ++offset) {
            this.plannedBlockQueue.add(new PlannedBlock(this.world, ((SculkBeeNestCellBlock)BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()).func_176223_P(), this.origin.func_177979_c(offset)));
        }
        BlockPos branchOrigin = new BlockPos(this.origin.func_177958_n(), this.origin.func_177956_o() - 2, this.origin.func_177952_p());
        this.plannedBlockQueue.addAll(this.generateBranchesPlan(branchOrigin));
    }

    private ArrayList<PlannedBlock> generateBranchesPlan(BlockPos origin) {
        BlockPos branch2Pos;
        BlockPos branch1Pos;
        int offset;
        ArrayList<PlannedBlock> branches = new ArrayList<PlannedBlock>();
        int branchLength = (int)BlockAlgorithms.getSudoRNGFromPosition(origin, 5, 8);
        int chanceToOffsetBranchSideways = 35;
        int branchSidewaysOffset = 0;
        for (offset = 1; offset <= branchLength; ++offset) {
            branch1Pos = new BlockPos(origin.func_177958_n() + offset, origin.func_177956_o(), origin.func_177952_p() + branchSidewaysOffset);
            branch2Pos = new BlockPos(origin.func_177958_n() - offset, origin.func_177956_o(), origin.func_177952_p() - branchSidewaysOffset);
            if (BlockAlgorithms.getSudoRNGFromPosition(branch1Pos, 0, 100) <= (float)chanceToOffsetBranchSideways) {
                ++branchSidewaysOffset;
            }
            branches.add(new SculkNestCellPlannedBlock(this.world, branch1Pos));
            branches.add(new SculkNestCellPlannedBlock(this.world, branch2Pos));
        }
        branchSidewaysOffset = 0;
        branchLength -= 2;
        for (offset = 1; offset <= branchLength; ++offset) {
            branch1Pos = new BlockPos(origin.func_177958_n() + branchSidewaysOffset, origin.func_177956_o() - 1, origin.func_177952_p() + offset);
            branch2Pos = new BlockPos(origin.func_177958_n() - branchSidewaysOffset, origin.func_177956_o() - 1, origin.func_177952_p() - offset);
            if (BlockAlgorithms.getSudoRNGFromPosition(branch1Pos, 0, 100) <= (float)chanceToOffsetBranchSideways) {
                ++branchSidewaysOffset;
            }
            branches.add(new SculkNestCellPlannedBlock(this.world, branch1Pos));
            branches.add(new SculkNestCellPlannedBlock(this.world, branch2Pos));
        }
        return branches;
    }

    public void makeRandomBlockMature() {
        for (PlannedBlock block : this.plannedBlockQueue) {
            if (!block.isPlaced() || (Integer)this.world.func_180495_p(block.getPosition()).func_177229_b((Property)SculkBeeNestCellBlock.MATURE) != 0) continue;
            ((SculkBeeNestCellBlock)BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()).setMature((World)this.world, this.world.func_180495_p(block.getPosition()), block.getPosition());
            return;
        }
    }

    private class SculkNestCellPlannedBlock
    extends PlannedBlock {
        public SculkNestCellPlannedBlock(ServerWorld worldIn, BlockState plannedBlockIn, BlockPos targetPosIn) {
            super(worldIn, plannedBlockIn, targetPosIn);
        }

        public SculkNestCellPlannedBlock(ServerWorld worldIn, BlockPos targetPosIn) {
            super(worldIn, ((SculkBeeNestCellBlock)BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()).func_176223_P(), targetPosIn);
        }

        @Override
        public boolean canBePlaced() {
            return this.VALID_BLOCKS_TO_REPLACE.test(this.world.func_180495_p(this.targetPos)) && !BlockAlgorithms.isExposedToAir(this.world, this.targetPos);
        }
    }
}

