/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.block.SculkLivingRockBlock;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class SculkLivingRockProceduralStructure
extends ProceduralStructure {
    public SculkLivingRockProceduralStructure(ServerWorld worldIn, BlockPos originIn) {
        super(worldIn, originIn);
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        for (ProceduralStructure entry : this.childStructuresQueue) {
            entry.generatePlan();
        }
        int DIAMETER = (int)BlockAlgorithms.getSudoRNGFromPosition(this.origin, 5, 9);
        int pillarOffsetX = (int)BlockAlgorithms.getSudoRNGFromPosition(this.origin, (DIAMETER / 2 - 1) * -1, DIAMETER / 2 - 1);
        int pillarOffsetZ = (int)BlockAlgorithms.getSudoRNGFromPosition(this.origin, (DIAMETER / 2 - 1) * -1, DIAMETER / 2 - 1);
        BlockPos highestPillar = this.origin.func_177982_a(pillarOffsetX, 0, pillarOffsetZ);
        int HEIGHT_DEGRADE_MULTIPLIER = DIAMETER / 2;
        int MAXIMUM_HEIGHT = Math.max(HEIGHT_DEGRADE_MULTIPLIER * DIAMETER, DIAMETER * 2);
        ArrayList<PlannedBlock> circleBase = BlockAlgorithms.generate2DCirclePlan(this.origin, DIAMETER, this.world, ((SculkLivingRockBlock)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()).func_176223_P());
        ArrayList<PlannedBlock> pillarList = new ArrayList<PlannedBlock>();
        for (PlannedBlock plannedBlock : circleBase) {
            BlockPos newPos;
            int y;
            BlockPos pos = plannedBlock.getPosition();
            int distanceFromHighestPillar = (int)BlockAlgorithms.getBlockDistance(highestPillar, pos);
            int height = MAXIMUM_HEIGHT - distanceFromHighestPillar * HEIGHT_DEGRADE_MULTIPLIER - (int)BlockAlgorithms.getSudoRNGFromPosition(pos, 0, 2);
            for (y = pos.func_177956_o(); y < pos.func_177956_o() + height; ++y) {
                newPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                if (BlockAlgorithms.getSudoRNGFromPosition(newPos, 0, 10) == 0.0f) {
                    pillarList.add(new PlannedBlock(this.world, ((Block)BlockRegistry.CALCITE_ORE.get()).func_176223_P(), newPos));
                    continue;
                }
                pillarList.add(new PlannedBlock(this.world, ((SculkLivingRockBlock)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()).func_176223_P(), newPos));
            }
            for (y = pos.func_177956_o(); y > pos.func_177956_o() - height; --y) {
                newPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                pillarList.add(new PlannedBlock(this.world, ((SculkLivingRockBlock)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()).func_176223_P(), newPos));
            }
        }
        this.plannedBlockQueue.addAll(circleBase);
        this.plannedBlockQueue.addAll(pillarList);
    }
}

