/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.procedural.structures.Line3D;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.core.BlockRegistry;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class SculkNodeCaveHallwayProceduralStructure
extends ProceduralStructure {
    private int radius = -1;
    private int length = -1;
    private Direction direction;

    public SculkNodeCaveHallwayProceduralStructure(ServerWorld worldIn, BlockPos originIn, int radiusIn, int length, Direction direction) {
        super(worldIn, originIn);
        this.radius = radiusIn;
        this.length = length;
        this.direction = direction;
        this.generatePlan();
    }

    @Override
    public void buildTick() {
        if (this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
            PlannedBlock currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
            while (currentPlannedBlock.canBePlaced() && currentPlannedBlock.isPlaced() && this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
                currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
                ++this.currentPlannedBlockQueueIndex;
            }
            if (currentPlannedBlock.canBePlaced()) {
                currentPlannedBlock.build();
            }
            ++this.currentPlannedBlockQueueIndex;
        }
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        ArrayList<BlockPos> plannedBlockPositions = this.createCaveBlockPositions();
        for (BlockPos position : plannedBlockPositions) {
            this.plannedBlockQueue.add(new CaveAirPlannedBlock(this.world, position));
        }
    }

    public ArrayList<BlockPos> createCaveBlockPositions() {
        Line3D line;
        switch (this.direction) {
            case NORTH: {
                line = new Line3D(this.origin, this.origin.func_177964_d(this.length));
                break;
            }
            case SOUTH: {
                line = new Line3D(this.origin, this.origin.func_177970_e(this.length));
                break;
            }
            case EAST: {
                line = new Line3D(this.origin, this.origin.func_177965_g(this.length));
                break;
            }
            case WEST: {
                line = new Line3D(this.origin, this.origin.func_177985_f(this.length));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction: " + this.direction);
            }
        }
        return line.getBlockPositionsOnLineWithSphere(this.radius);
    }

    public class CaveAirPlannedBlock
    extends PlannedBlock {
        protected final Predicate<BlockState> CAN_BLOCK_BE_REPLACED;

        public CaveAirPlannedBlock(ServerWorld worldIn, BlockPos targetPosIn) {
            super(worldIn, Blocks.field_201941_jj.func_176223_P(), targetPosIn);
            this.CAN_BLOCK_BE_REPLACED = validBlocksPredicate -> {
                if (validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_NODE_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_DURA_MATTER.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_ARACHNOID.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_SUMMONER_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.GRASS.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.GRASS_SHORT.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.CALCITE_ORE.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SMALL_SHROOM.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.VEIN.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_SHROOM_CULTURE.get())) {
                    return false;
                }
                if (this.world.func_226660_f_(this.targetPos.func_177984_a())) {
                    return false;
                }
                return !(validBlocksPredicate.func_185887_b((IBlockReader)this.world, this.targetPos) > 3.0f);
            };
        }

        @Override
        public boolean canBePlaced() {
            return this.CAN_BLOCK_BE_REPLACED.test(this.world.func_180495_p(this.targetPos));
        }

        @Override
        public void build() {
            if (this.canBePlaced()) {
                this.world.func_175656_a(this.targetPos, this.plannedBlock);
            }
        }
    }

    private class CaveWallPlannedBlock
    extends PlannedBlock {
        protected final Predicate<BlockState> CAN_BLOCK_BE_REPLACED;

        public CaveWallPlannedBlock(ServerWorld worldIn, BlockPos targetPosIn) {
            super(worldIn, Blocks.field_201941_jj.func_176223_P(), targetPosIn);
            this.CAN_BLOCK_BE_REPLACED = validBlocksPredicate -> validBlocksPredicate.func_196958_f();
        }

        @Override
        public boolean canBePlaced() {
            return this.CAN_BLOCK_BE_REPLACED.test(this.world.func_180495_p(this.targetPos));
        }

        @Override
        public void build() {
            if (this.canBePlaced()) {
                this.world.func_175656_a(this.targetPos, this.plannedBlock);
            }
        }
    }
}

