/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.common.procedural.structures.SculkNodeCaveHallwayProceduralStructure;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class SculkNodeCaveProceduralStructure
extends ProceduralStructure {
    private int radius;
    SculkNodeCaveHallwayProceduralStructure westCave;
    SculkNodeCaveHallwayProceduralStructure eastCave;
    SculkNodeCaveHallwayProceduralStructure northCave;
    SculkNodeCaveHallwayProceduralStructure southCave;

    public SculkNodeCaveProceduralStructure(ServerWorld worldIn, BlockPos originIn, int radiusIn) {
        super(worldIn, originIn);
        this.radius = radiusIn;
        this.generatePlan();
    }

    @Override
    public void buildTick() {
        if (this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
            PlannedBlock currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
            while (currentPlannedBlock.canBePlaced() && currentPlannedBlock.isPlaced() && this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
                currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
                ++this.currentPlannedBlockQueueIndex;
            }
            if (currentPlannedBlock.canBePlaced()) {
                currentPlannedBlock.build();
            }
            ++this.currentPlannedBlockQueueIndex;
        }
        this.westCave.buildTick();
        this.eastCave.buildTick();
        this.northCave.buildTick();
        this.southCave.buildTick();
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        ArrayList<BlockPos> blockPositionsInCircle = BlockAlgorithms.getBlockPosInCircle(this.origin, this.radius, false);
        for (BlockPos position : blockPositionsInCircle) {
            this.plannedBlockQueue.add(new CaveAirPlannedBlock(this.world, position));
        }
        ProceduralStructure.ConnectionPoint westConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vector3i)this.origin.func_177982_a(-this.radius, 0, 0)), Direction.WEST);
        ProceduralStructure.ConnectionPoint eastConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vector3i)this.origin.func_177982_a(this.radius, 0, 0)), Direction.EAST);
        ProceduralStructure.ConnectionPoint northConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vector3i)this.origin.func_177982_a(0, 0, -this.radius)), Direction.NORTH);
        ProceduralStructure.ConnectionPoint southConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vector3i)this.origin.func_177982_a(0, 0, this.radius)), Direction.SOUTH);
        this.westCave = new SculkNodeCaveHallwayProceduralStructure(this.world, westConnection.getPosition(), 5, 32, Direction.WEST);
        this.eastCave = new SculkNodeCaveHallwayProceduralStructure(this.world, eastConnection.getPosition(), 5, 32, Direction.EAST);
        this.northCave = new SculkNodeCaveHallwayProceduralStructure(this.world, northConnection.getPosition(), 5, 32, Direction.NORTH);
        this.southCave = new SculkNodeCaveHallwayProceduralStructure(this.world, southConnection.getPosition(), 5, 32, Direction.SOUTH);
    }

    public class CaveAirPlannedBlock
    extends PlannedBlock {
        protected final Predicate<BlockState> CAN_BLOCK_BE_REPLACED;

        public CaveAirPlannedBlock(ServerWorld worldIn, BlockPos targetPosIn) {
            super(worldIn, Blocks.field_201941_jj.func_176223_P(), targetPosIn);
            this.CAN_BLOCK_BE_REPLACED = validBlocksPredicate -> {
                if (validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_NODE_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_DURA_MATTER.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_ARACHNOID.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_SUMMONER_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.GRASS.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.GRASS_SHORT.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.CALCITE_ORE.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SMALL_SHROOM.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.VEIN.get()) || validBlocksPredicate.func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_SHROOM_CULTURE.get())) {
                    return false;
                }
                if (this.world.func_226660_f_(this.targetPos.func_177984_a())) {
                    return false;
                }
                return !(validBlocksPredicate.func_185887_b((IBlockReader)this.world, this.targetPos) > 3.0f);
            };
        }

        @Override
        public boolean canBePlaced() {
            return this.CAN_BLOCK_BE_REPLACED.test(this.world.func_180495_p(this.targetPos));
        }

        @Override
        public void build() {
            if (this.canBePlaced()) {
                this.world.func_175656_a(this.targetPos, this.plannedBlock);
            }
        }
    }
}

