/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.block.SculkLivingRockRootBlock;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.common.procedural.structures.SculkNodeCaveProceduralStructure;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class SculkNodeProceduralStructure
extends ProceduralStructure {
    private final int SHELL_RADIUS = 5;
    private final int CAVE_RADIUS = 10;
    private final int HALLWAY_RADIUS = 5;

    public SculkNodeProceduralStructure(ServerWorld worldIn, BlockPos originIn) {
        super(worldIn, originIn);
    }

    @Override
    public void buildTick() {
        super.buildTick();
        for (ProceduralStructure childStructure : this.childStructuresQueue) {
            childStructure.buildTick();
        }
    }

    public Optional<BlockPos> findLivingRockStructureIfExists(ServerWorld world, BlockPos placementPos) {
        if (world.func_180495_p(placementPos).func_177230_c().equals(BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())) {
            return Optional.of(placementPos);
        }
        int offsetBelow = 0;
        int offsetAbove = 0;
        while (placementPos.func_177982_a(0, offsetBelow, 0).func_177956_o() > 0) {
            if (world.func_180495_p(placementPos.func_177982_a(0, offsetBelow, 0)).func_177230_c().equals(BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())) {
                return Optional.of(placementPos.func_177982_a(0, offsetBelow, 0));
            }
            --offsetBelow;
        }
        while (placementPos.func_177982_a(0, offsetAbove, 0).func_177956_o() > world.func_234938_ad_()) {
            if (world.func_180495_p(placementPos.func_177982_a(0, offsetAbove, 0)).func_177230_c().equals(BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())) {
                return Optional.of(placementPos.func_177982_a(0, offsetAbove, 0));
            }
            ++offsetAbove;
        }
        return Optional.empty();
    }

    public BlockPos findLivingRockPlacementPosition(ServerWorld world, BlockPos placementPos) {
        int attempts;
        if (this.findLivingRockStructureIfExists(world, placementPos).isPresent()) {
            return this.findLivingRockStructureIfExists(world, placementPos).get();
        }
        int MAX_ATTEMPTS = 100;
        int offsetBelow = 0;
        int offsetAbove = 0;
        for (attempts = 0; world.func_180495_p(placementPos.func_177982_a(0, offsetBelow, 0)).func_227032_a_((Fluid)Fluids.field_204546_a) && attempts <= MAX_ATTEMPTS; ++attempts) {
            --offsetBelow;
        }
        for (attempts = 0; world.func_180495_p(placementPos.func_177982_a(0, offsetAbove, 0)).func_227032_a_((Fluid)Fluids.field_204546_a) && attempts <= MAX_ATTEMPTS; ++attempts) {
            ++offsetAbove;
        }
        if (Math.abs(offsetBelow) < offsetAbove) {
            return placementPos.func_177982_a(0, offsetBelow, 0);
        }
        return placementPos.func_177982_a(0, offsetAbove, 0);
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        this.childStructuresQueue.add(new SculkNodeCaveProceduralStructure(this.world, this.origin, 10));
        for (Object entry : this.childStructuresQueue) {
            ((ProceduralStructure)entry).generatePlan();
        }
        ArrayList<BlockPos> blockPositionsInCircle = BlockAlgorithms.getBlockPosInCircle(this.origin, 5, false);
        for (BlockPos position : blockPositionsInCircle) {
            if (BlockAlgorithms.getBlockDistance(this.origin, position) < 4.0f) {
                this.plannedBlockQueue.add(new PlannedBlock(this.world, ((Block)BlockRegistry.SCULK_ARACHNOID.get()).func_176223_P(), position));
                continue;
            }
            this.plannedBlockQueue.add(new PlannedBlock(this.world, ((Block)BlockRegistry.SCULK_DURA_MATTER.get()).func_176223_P(), position));
        }
        ArrayList<BlockPos> surroundingLivingRock = BlockAlgorithms.getPointsOnCircumference(this.origin, 5, 15);
        surroundingLivingRock.addAll(BlockAlgorithms.getPointsOnCircumference(this.origin, 10, 30));
        surroundingLivingRock.addAll(BlockAlgorithms.getPointsOnCircumference(this.origin, 20, 45));
        for (BlockPos position : surroundingLivingRock) {
            this.plannedBlockQueue.add(new PlannedBlock(this.world, ((SculkLivingRockRootBlock)BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get()).func_176223_P(), this.findLivingRockPlacementPosition(this.world, position)));
        }
    }
}

