/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.tileentity;

import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.infection.CursorInfectorEntity;
import com.github.sculkhorde.common.procedural.structures.SculkBeeNestProceduralStructure;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.TileEntityRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SculkBeeNestTile
extends TileEntity
implements ITickableTileEntity {
    private final List<Bee> stored = Lists.newArrayList();
    private SculkBeeNestProceduralStructure beeNestStructure;
    private int tickTracker = 0;
    protected final int MAX_HONEY_LEVEL = 5;
    protected final int MIN_TICKS_IN_HIVE = 6000;
    private long lastTimeSinceRepair = -1L;

    public SculkBeeNestTile() {
        super((TileEntityType)TileEntityRegistry.SCULK_BEE_NEST_TILE.get());
    }

    public void func_70296_d() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.field_145850_b.func_180495_p(this.func_174877_v()), State.EMERGENCY);
        }
        super.func_70296_d();
    }

    public static int getHoneyLevel(BlockState pState) {
        return (Integer)pState.func_177229_b((Property)SculkBeeNestBlock.HONEY_LEVEL);
    }

    public boolean isSedated() {
        assert (this.field_145850_b != null);
        return CampfireBlock.func_235474_a_((World)this.field_145850_b, (BlockPos)this.func_174877_v());
    }

    public boolean isFireNearby() {
        if (this.field_145850_b == null) {
            return false;
        }
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            if (!(this.field_145850_b.func_180495_p(blockpos).func_177230_c() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 10;
    }

    public void emptyAllLivingFromHive(@Nullable PlayerEntity pPlayer, BlockState pState, State pReleaseStatus) {
        List<Entity> list = this.releaseAllOccupants(pState, pReleaseStatus);
        if (pPlayer != null) {
            return;
        }
        for (Entity entity : list) {
            if (!(entity instanceof SculkBeeHarvesterEntity) || pPlayer.func_213303_ch().func_72436_e(entity.func_213303_ch()) > 16.0) continue;
            SculkBeeHarvesterEntity beeentity = (SculkBeeHarvesterEntity)entity;
            if (this.isSedated()) continue;
            beeentity.func_70624_b((LivingEntity)pPlayer);
        }
    }

    private List<Entity> releaseAllOccupants(BlockState blockState, State releaseStatus) {
        ArrayList releasedEntities = Lists.newArrayList();
        this.stored.removeIf(occupant -> this.releaseOccupant(blockState, (Bee)occupant, releasedEntities, releaseStatus));
        return releasedEntities;
    }

    public void addOccupant(Entity entityIn) {
        this.addOccupantWithPresetTicks(entityIn, 0);
    }

    public void addOccupantWithPresetTicks(Entity entityIn, int ticksInHive) {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.stored.size() >= 10) {
            return;
        }
        entityIn.func_184210_p();
        entityIn.func_184226_ay();
        CompoundNBT compoundnbt = new CompoundNBT();
        entityIn.func_70039_c(compoundnbt);
        this.stored.add(new Bee(compoundnbt, ticksInHive, 6000));
        this.stored.get(0);
        BlockPos blockpos = this.func_174877_v();
        this.field_145850_b.func_184148_a(null, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
        entityIn.func_70106_y();
    }

    private boolean releaseOccupant(BlockState blockStateIn, Bee entityIn, @Nullable List<Entity> entityListIn, State state2) {
        boolean isEnteranceBlocked;
        if (SculkBeeNestBlock.isNestClosed(blockStateIn)) {
            return false;
        }
        Direction direction = (Direction)blockStateIn.func_177229_b((Property)SculkBeeNestBlock.FACING);
        BlockPos frontOfHive = this.func_174877_v().func_177972_a(direction);
        boolean bl = isEnteranceBlocked = !this.field_145850_b.func_180495_p(frontOfHive).func_196952_d((IBlockReader)this.field_145850_b, frontOfHive).func_197766_b();
        if (isEnteranceBlocked && state2 != State.EMERGENCY) {
            return false;
        }
        CompoundNBT compoundnbt = entityIn.entityData;
        compoundnbt.func_82580_o("Passengers");
        compoundnbt.func_82580_o("Leash");
        compoundnbt.func_82580_o("UUID");
        Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)this.field_145850_b, p_226960_0_ -> p_226960_0_);
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof SculkBeeHarvesterEntity)) {
            return false;
        }
        SculkBeeHarvesterEntity beeentity = (SculkBeeHarvesterEntity)entity;
        if (state2 == State.HONEY_DELIVERED) {
            beeentity.dropOffNectar();
            int currentHoneyLevel = SculkBeeNestTile.getHoneyLevel(blockStateIn);
            if (this.beeNestStructure != null) {
                this.beeNestStructure.makeRandomBlockMature();
            }
            for (int i = 0; i < SculkBeeNestTile.getHoneyLevel(blockStateIn); ++i) {
                CursorInfectorEntity cursor = new CursorInfectorEntity(this.field_145850_b);
                cursor.func_70107_b(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
                cursor.setMaxRange(100);
                cursor.setMaxInfections(100);
                this.field_145850_b.func_217376_c((Entity)cursor);
            }
            if (currentHoneyLevel < 5) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)blockStateIn.func_206870_a((Property)SculkBeeNestBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(currentHoneyLevel + 1)));
            }
        }
        this.setBeeReleaseData(entityIn.ticksInHive, beeentity);
        if (entityListIn != null) {
            entityListIn.add((Entity)beeentity);
        }
        float f = entity.func_213311_cf();
        double d3 = isEnteranceBlocked ? 0.0 : 0.55 + (double)(f / 2.0f);
        double d0 = (double)this.func_174877_v().func_177958_n() + 0.5 + d3 * (double)direction.func_82601_c();
        double d1 = (double)this.func_174877_v().func_177956_o() + 0.5 - (double)(entity.func_213302_cg() / 2.0f);
        double d2 = (double)this.func_174877_v().func_177952_p() + 0.5 + d3 * (double)direction.func_82599_e();
        entity.func_70012_b(d0, d1, d2, entity.field_70177_z, entity.field_70125_A);
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return this.field_145850_b.func_217376_c(entity);
    }

    private void setBeeReleaseData(int p_235650_1_, SculkBeeHarvesterEntity p_235650_2_) {
        p_235650_2_.resetTicksWithoutNectarSinceExitingHive();
    }

    private void tickOccupants() {
        Iterator<Bee> iterator = this.stored.iterator();
        BlockState blockstate = this.func_195044_w();
        while (iterator.hasNext()) {
            Bee sculkbeenesttile$bee = iterator.next();
            if (sculkbeenesttile$bee.ticksInHive > sculkbeenesttile$bee.minOccupationTicks) {
                State sculkbeenesttile$state;
                State state2 = sculkbeenesttile$state = sculkbeenesttile$bee.entityData.func_74767_n("HasNectar") ? State.HONEY_DELIVERED : State.BEE_RELEASED;
                if (this.releaseOccupant(blockstate, sculkbeenesttile$bee, null, sculkbeenesttile$state)) {
                    iterator.remove();
                }
            }
            sculkbeenesttile$bee.ticksInHive++;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickOccupants();
        BlockPos blockpos = this.func_174877_v();
        if (this.stored.size() > 0 && this.field_145850_b.func_201674_k().nextDouble() < 0.005) {
            double d0 = (double)blockpos.func_177958_n() + 0.5;
            double d1 = blockpos.func_177956_o();
            double d2 = (double)blockpos.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, d0, d1, d2, SoundEvents.field_226134_ai_, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (SculkBeeNestTile.getHoneyLevel(this.func_195044_w()) >= 4) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)SculkBeeNestBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
            SculkHorde.gravemind.getGravemindMemory().addSculkAccumulatedMass(10);
        }
        ++this.tickTracker;
        if (this.tickTracker < 1200) {
            return;
        }
        this.tickTracker = 0;
        long timeElapsed = TimeUnit.MINUTES.convert(System.nanoTime() - this.lastTimeSinceRepair, TimeUnit.NANOSECONDS);
        if (this.beeNestStructure == null) {
            this.beeNestStructure = new SculkBeeNestProceduralStructure((ServerWorld)this.field_145850_b, this.func_174877_v());
            this.beeNestStructure.generatePlan();
        }
        long repairIntervalInMinutes = 30L;
        if (this.beeNestStructure.isCurrentlyBuilding()) {
            this.beeNestStructure.buildTick();
            this.lastTimeSinceRepair = System.nanoTime();
        } else if ((timeElapsed >= repairIntervalInMinutes || this.lastTimeSinceRepair == -1L) && this.beeNestStructure.canStartToBuild()) {
            this.beeNestStructure.startBuildProcedure();
        }
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.stored.clear();
        ListNBT listnbt = p_230337_2_.func_150295_c("Bees", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Bee sculkbeenesttile$bee = new Bee(compoundnbt.func_74775_l("EntityData"), compoundnbt.func_74762_e("TicksInHive"), compoundnbt.func_74762_e("MinOccupationTicks"));
            this.stored.add(sculkbeenesttile$bee);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT pCompound) {
        super.func_189515_b(pCompound);
        pCompound.func_218657_a("Bees", (INBT)this.writeBees());
        return pCompound;
    }

    public ListNBT writeBees() {
        ListNBT listnbt = new ListNBT();
        for (Bee sculkbeenesttile$bee : this.stored) {
            sculkbeenesttile$bee.entityData.func_82580_o("UUID");
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_218657_a("EntityData", (INBT)sculkbeenesttile$bee.entityData);
            compoundnbt.func_74768_a("TicksInHive", sculkbeenesttile$bee.ticksInHive);
            compoundnbt.func_74768_a("MinOccupationTicks", sculkbeenesttile$bee.minOccupationTicks);
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }

    public static enum State {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY,
        DISABLED;

    }

    static class Bee {
        private final CompoundNBT entityData;
        private int ticksInHive;
        private final int minOccupationTicks;

        private Bee(CompoundNBT pEntityData, int pTicksInHive, int pMinOccupationTicks) {
            pEntityData.func_82580_o("UUID");
            this.entityData = pEntityData;
            this.ticksInHive = pTicksInHive;
            this.minOccupationTicks = pMinOccupationTicks;
        }
    }
}

