/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.tileentity;

import com.github.sculkhorde.common.procedural.structures.SculkLivingRockProceduralStructure;
import com.github.sculkhorde.core.TileEntityRegistry;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.server.ServerWorld;

public class SculkLivingRockRootTile
extends TileEntity
implements ITickableTileEntity {
    private long tickedAt = System.nanoTime();
    private SculkLivingRockProceduralStructure proceduralStructure;
    private final long repairIntervalInMinutes = 60L;
    private long lastTimeSinceRepair = -1L;

    public SculkLivingRockRootTile(TileEntityType<?> type) {
        super(type);
    }

    public SculkLivingRockRootTile() {
        this((TileEntityType)TileEntityRegistry.SCULK_LIVING_ROCK_ROOT_TILE.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - this.tickedAt, TimeUnit.NANOSECONDS);
        if ((double)timeElapsed < 0.1) {
            return;
        }
        this.tickedAt = System.nanoTime();
        long repairTimeElapsed = TimeUnit.MINUTES.convert(System.nanoTime() - this.lastTimeSinceRepair, TimeUnit.NANOSECONDS);
        if (this.proceduralStructure == null) {
            this.proceduralStructure = new SculkLivingRockProceduralStructure((ServerWorld)this.field_145850_b, this.func_174877_v());
            this.proceduralStructure.generatePlan();
        }
        if (this.proceduralStructure.isCurrentlyBuilding()) {
            this.proceduralStructure.buildTick();
            this.lastTimeSinceRepair = System.nanoTime();
        } else if (repairTimeElapsed >= 60L || this.lastTimeSinceRepair == -1L) {
            this.proceduralStructure.startBuildProcedure();
        }
    }
}

