/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.tileentity;

import com.github.sculkhorde.common.entity.infection.SculkNodeInfectionHandler;
import com.github.sculkhorde.common.procedural.structures.SculkNodeProceduralStructure;
import com.github.sculkhorde.core.TileEntityRegistry;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;

public class SculkNodeTile
extends TileEntity
implements ITickableTileEntity {
    private final int CHUNK_LOAD_RADIUS = 15;
    private long tickedAt = System.nanoTime();
    private SculkNodeProceduralStructure nodeProceduralStructure;
    private final long repairIntervalInMinutes = 60L;
    private long lastTimeSinceRepair = -1L;
    public static final int tickIntervalSeconds = 1;
    private SculkNodeInfectionHandler infectionHandler;

    public SculkNodeTile(TileEntityType<?> type) {
        super(type);
    }

    public SculkNodeTile() {
        this((TileEntityType)TileEntityRegistry.SCULK_BRAIN_TILE.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - this.tickedAt, TimeUnit.NANOSECONDS);
            if (timeElapsed < 1L) {
                return;
            }
            this.tickedAt = System.nanoTime();
            long repairTimeElapsed = TimeUnit.MINUTES.convert(System.nanoTime() - this.lastTimeSinceRepair, TimeUnit.NANOSECONDS);
            if (this.nodeProceduralStructure == null) {
                this.nodeProceduralStructure = new SculkNodeProceduralStructure((ServerWorld)this.field_145850_b, this.func_174877_v());
                this.nodeProceduralStructure.generatePlan();
            }
            if (this.nodeProceduralStructure.isCurrentlyBuilding()) {
                this.nodeProceduralStructure.buildTick();
                this.lastTimeSinceRepair = System.nanoTime();
            } else if ((repairTimeElapsed >= 60L || this.lastTimeSinceRepair == -1L) && this.nodeProceduralStructure.canStartToBuild()) {
                this.nodeProceduralStructure.startBuildProcedure();
            }
            if (this.infectionHandler == null) {
                this.infectionHandler = new SculkNodeInfectionHandler(this);
            } else {
                this.infectionHandler.tick();
            }
        }
    }

    public static void forceLoadChunk(ServerWorld world, BlockPos owner, int chunkX, int chunkZ, boolean tickingWithoutPlayer) {
        ForgeChunkManager.forceChunk((ServerWorld)world, (String)"sculkhorde", (BlockPos)owner, (int)chunkX, (int)chunkZ, (boolean)true, (boolean)true);
    }

    public void forceLoadChunksInRadius(ServerWorld world, BlockPos owner, int chunkOriginX, int chunkOriginZ) {
        int startChunkX = chunkOriginX - 15;
        int startChunkZ = chunkOriginZ - 15;
        for (int xOffset = 0; xOffset < 31; ++xOffset) {
            for (int zOffset = 0; zOffset < 31; ++zOffset) {
                SculkNodeTile.forceLoadChunk(world, owner, startChunkX + xOffset, startChunkZ + zOffset, true);
            }
        }
    }

    public static void unloadChunk(ServerWorld world, BlockPos owner, int chunkX, int chunkZ, boolean tickingWithoutPlayer) {
        ForgeChunkManager.forceChunk((ServerWorld)world, (String)"sculkhorde", (BlockPos)owner, (int)chunkX, (int)chunkZ, (boolean)false, (boolean)false);
    }

    public void unloadChunksInRadius(ServerWorld world, BlockPos owner, int chunkOriginX, int chunkOriginZ) {
        int startChunkX = chunkOriginX - 15;
        int startChunkZ = chunkOriginZ - 15;
        for (int xOffset = 0; xOffset < 31; ++xOffset) {
            for (int zOffset = 0; zOffset < 31; ++zOffset) {
                SculkNodeTile.unloadChunk(world, owner, startChunkX + xOffset, startChunkZ + zOffset, true);
            }
        }
    }
}

