/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.tileentity;

import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.TileEntityRegistry;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class SculkSummonerTile
extends TileEntity
implements ITickableTileEntity {
    private int behavior_state = 0;
    private final int STATE_COOLDOWN = 0;
    private final int STATE_READY_TO_SPAWN = 1;
    private final int STATE_SPAWNING = 2;
    AxisAlignedBB searchArea;
    private final int ACTIVATION_DISTANCE = 32;
    private List<LivingEntity> possibleLivingEntityTargets;
    private List<LivingEntity> possibleAggressorTargets;
    private long lastTimeOfTick = System.nanoTime();
    private long timeElapsedSinceTick = 0L;
    private long lastTimeOfAlert = 0L;
    private int alertPeriodSeconds = 60;
    private long tickIntervalAlertSeconds = 30L;
    private long tickIntervalUnAlertSeconds = 60L;
    private long lastTimeOfSummon = 0L;
    private final int MAX_SPAWNED_ENTITIES = 4;
    ReinforcementRequest request;
    private TargetParameters hostileTargetParameters = new TargetParameters().enableTargetHostiles().enableTargetInfected();
    private TargetParameters infectableTargetParameters = new TargetParameters().enableTargetPassives();
    private final Predicate<BlockPos> VALID_SPAWN_BLOCKS = blockPos -> this.isValidSpawnPosition((ServerWorld)this.field_145850_b, (BlockPos)blockPos);

    public SculkSummonerTile(TileEntityType<?> type) {
        super(type);
    }

    public SculkSummonerTile() {
        this((TileEntityType)TileEntityRegistry.SCULK_SUMMONER_TILE.get());
        this.searchArea = EntityAlgorithms.getSearchAreaRectangle(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 32.0, 5.0, 32.0);
    }

    public boolean isCurrentlyAlert() {
        return TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTimeOfAlert, TimeUnit.NANOSECONDS) <= (long)this.alertPeriodSeconds;
    }

    private boolean areAllReinforcementsDead() {
        if (this.request == null) {
            return true;
        }
        for (LivingEntity entity : this.request.spawnedEntities) {
            if (entity == null || !entity.func_70089_S()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass() <= 0) {
            return;
        }
        this.timeElapsedSinceTick = TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTimeOfTick, TimeUnit.NANOSECONDS);
        if (this.isCurrentlyAlert() && this.timeElapsedSinceTick < this.tickIntervalAlertSeconds) {
            return;
        }
        if (!this.isCurrentlyAlert() && this.timeElapsedSinceTick < this.tickIntervalUnAlertSeconds) {
            return;
        }
        this.lastTimeOfTick = System.nanoTime();
        if (this.behavior_state == 0) {
            this.behavior_state = 1;
        }
        if (this.behavior_state == 1) {
            if (!this.areAllReinforcementsDead()) {
                return;
            }
            this.searchArea = EntityAlgorithms.getSearchAreaRectangle(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 32.0, 5.0, 32.0);
            this.possibleAggressorTargets = this.field_145850_b.func_225316_b(LivingEntity.class, this.searchArea, this.hostileTargetParameters.isPossibleNewTargetValid);
            this.possibleLivingEntityTargets = this.field_145850_b.func_225316_b(LivingEntity.class, this.searchArea, this.infectableTargetParameters.isPossibleNewTargetValid);
            if (this.possibleAggressorTargets.size() == 0 && this.possibleLivingEntityTargets.size() == 0) {
                return;
            }
            this.behavior_state = 2;
        }
        if (this.behavior_state == 2) {
            ArrayList<BlockPos> possibleSpawnPositions = this.getSpawnPositionsInCube((ServerWorld)this.field_145850_b, this.func_174877_v(), 5, 4);
            BlockPos[] finalizedSpawnPositions = new BlockPos[4];
            for (int iterations = 0; iterations < possibleSpawnPositions.size(); ++iterations) {
                finalizedSpawnPositions[iterations] = possibleSpawnPositions.isEmpty() ? this.func_174877_v().func_177984_a() : possibleSpawnPositions.get(iterations);
            }
            this.request = new ReinforcementRequest(finalizedSpawnPositions);
            this.request.sender = ReinforcementRequest.senderType.SculkCocoon;
            if (this.possibleAggressorTargets.size() != 0) {
                this.request.is_aggressor_nearby = true;
                this.lastTimeOfAlert = System.nanoTime();
            }
            if (this.possibleLivingEntityTargets.size() != 0) {
                this.request.is_non_sculk_mob_nearby = true;
                this.lastTimeOfAlert = System.nanoTime();
            }
            if (this.request.is_non_sculk_mob_nearby || this.request.is_aggressor_nearby) {
                SculkHorde.entityFactory.requestReinforcementAny(this.field_145850_b, this.func_174877_v(), false, this.request);
            }
            this.behavior_state = 0;
        }
    }

    public ArrayList<BlockPos> getSpawnPositionsInCube(ServerWorld worldIn, BlockPos origin, int length, int amountOfPositions) {
        ArrayList<BlockPos> listOfPossibleSpawns = BlockAlgorithms.getBlocksInCube(worldIn, origin, this.VALID_SPAWN_BLOCKS, length);
        ArrayList<BlockPos> finalList = new ArrayList<BlockPos>();
        Random rng = new Random();
        for (int count = 0; count < amountOfPositions && listOfPossibleSpawns.size() > 0; ++count) {
            int randomIndex = rng.nextInt(listOfPossibleSpawns.size());
            finalList.add(listOfPossibleSpawns.get(randomIndex));
            listOfPossibleSpawns.remove(randomIndex);
        }
        return finalList;
    }

    public boolean isValidSpawnPosition(ServerWorld worldIn, BlockPos pos) {
        return SculkHorde.infestationConversionTable.infestationTable.isInfectedVariant(worldIn.func_180495_p(pos.func_177977_b())) && worldIn.func_180495_p(pos).func_227032_a_((Fluid)Fluids.field_204546_a) && worldIn.func_180495_p(pos.func_177984_a()).func_227032_a_((Fluid)Fluids.field_204546_a);
    }
}

