/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.world.gen;

import com.github.sculkhorde.common.entity.SculkMiteEntity;
import com.github.sculkhorde.core.EntityRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModEntityGen {
    public static void onEntitySpawn(BiomeLoadingEvent event) {
        ModEntityGen.addEntityToAllBiomesExceptThese(event, EntityRegistry.SCULK_MITE, SculkMiteEntity.SPAWN_WEIGHT, SculkMiteEntity.SPAWN_MIN, SculkMiteEntity.SPAWN_MAX, Biomes.field_76771_b, Biomes.field_203616_V);
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            ModEntityGen.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            ModEntityGen.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomes(MobSpawnInfoBuilder spawns, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = spawns.getSpawner(type.func_220339_d());
        base.add(new MobSpawnInfo.Spawners(type, weight, minCount, maxCount));
    }
}

