/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.block.SculkNodeBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Gravemind {
    private evolution_states evolution_state = evolution_states.Undeveloped;
    public static EntityFactory entityFactory;
    public GravemindMemory gravemindMemory;
    private static final int MINIMUM_DISTANCE_BETWEEN_NODES = 300;
    private final int SCULK_NODE_INFECT_RADIUS_UNDEVELOPED = 10;
    public int sculk_node_infect_radius = 10;
    public int sculk_node_limit = 1;

    public Gravemind() {
        entityFactory = SculkHorde.entityFactory;
        this.gravemindMemory = (GravemindMemory)ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x().func_215752_a(() -> new GravemindMemory(), "sculkhorde_gravemind_memory");
        this.calulateCurrentState();
    }

    public evolution_states getEvolutionState() {
        return this.evolution_state;
    }

    @Nullable
    public GravemindMemory getGravemindMemory() {
        if (this.gravemindMemory == null) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return null;
            }
            DimensionSavedDataManager savedData = ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x();
            this.gravemindMemory = (GravemindMemory)savedData.func_215752_a(() -> new GravemindMemory(), "sculkhorde_gravemind_memory");
        }
        return this.gravemindMemory;
    }

    public void calulateCurrentState() {
        int MASS_GOAL_FOR_IMMATURE = 500;
        int MASS_GOAL_FOR_MATURE = 100000000;
        if (this.getGravemindMemory().getSculkAccumulatedMass() >= MASS_GOAL_FOR_IMMATURE) {
            this.sculk_node_infect_radius = 20;
            this.evolution_state = evolution_states.Immature;
        } else if (this.getGravemindMemory().getSculkAccumulatedMass() >= MASS_GOAL_FOR_MATURE) {
            this.sculk_node_infect_radius = 50;
            this.evolution_state = evolution_states.Mature;
            this.sculk_node_limit = 2;
        }
    }

    public void enableAmountOfBeeHives(ServerWorld worldIn, int amount) {
        if (this.getGravemindMemory().getBeeNestEntries().size() <= 0) {
            return;
        }
        int lastEnabledIndex = -1;
        for (int i = 0; i < this.getGravemindMemory().getBeeNestEntries().size(); ++i) {
            BeeNestEntry entry = this.getGravemindMemory().getBeeNestEntries().get(i);
            if (!entry.isEntryValid(worldIn) || entry.isOccupantsExistingDisabled(worldIn)) continue;
            entry.disableOccupantsExiting(worldIn);
            lastEnabledIndex = i;
        }
        int startIndex = lastEnabledIndex + 1;
        if (startIndex >= this.getGravemindMemory().getBeeNestEntries().size()) {
            startIndex = 0;
        }
        for (int i = startIndex; i < startIndex + amount; ++i) {
            int index = i % this.getGravemindMemory().getBeeNestEntries().size();
            if (!this.getGravemindMemory().getBeeNestEntries().get(index).isEntryValid(worldIn)) continue;
            this.getGravemindMemory().getBeeNestEntries().get(index).enableOccupantsExiting(worldIn);
        }
    }

    public boolean processReinforcementRequest(ReinforcementRequest context) {
        context.isRequestViewed = true;
        if (context.sender == ReinforcementRequest.senderType.Developer || context.sender == ReinforcementRequest.senderType.SculkMass) {
            context.isRequestApproved = true;
        }
        if (SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass() <= 0) {
            return false;
        }
        if (this.evolution_state == evolution_states.Undeveloped) {
            context.isRequestApproved = true;
        } else if (this.evolution_state == evolution_states.Immature) {
            if (context.is_aggressor_nearby) {
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Melee);
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Ranged);
                context.isRequestApproved = true;
            } else if (context.is_non_sculk_mob_nearby) {
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Infector);
                context.isRequestApproved = true;
            }
        }
        return context.isRequestApproved;
    }

    public boolean isEvolutionStateEqualOrLessThanCurrent(evolution_states stateIn) {
        if (this.evolution_state == evolution_states.Undeveloped) {
            return stateIn == evolution_states.Undeveloped;
        }
        if (this.evolution_state == evolution_states.Immature) {
            return stateIn == evolution_states.Immature || stateIn == evolution_states.Undeveloped;
        }
        if (this.evolution_state == evolution_states.Mature) {
            return stateIn == evolution_states.Undeveloped || stateIn == evolution_states.Immature || stateIn == evolution_states.Mature;
        }
        return false;
    }

    public void placeSculkNode(ServerWorld worldIn, BlockPos targetPos, boolean enableChance) {
        if (new Random().nextInt(10000) > 1 && enableChance) {
            return;
        }
        if (!SculkHorde.gravemind.isValidPositionForSculkNode(worldIn, targetPos)) {
            return;
        }
        SculkNodeBlock.FindAreaAndPlaceNode(worldIn, targetPos);
    }

    public boolean isValidPositionForSculkNode(ServerWorld worldIn, BlockPos positionIn) {
        if (worldIn.func_226660_f_(positionIn)) {
            return false;
        }
        if (SculkHorde.gravemind.getGravemindMemory().getNodeEntries().size() >= SculkHorde.gravemind.sculk_node_limit) {
            return false;
        }
        for (NodeEntry entry : this.getGravemindMemory().getNodeEntries()) {
            int distanceFromPotentialToCurrentNode = (int)BlockAlgorithms.getBlockDistance(positionIn, entry.position);
            if (distanceFromPotentialToCurrentNode >= 300) continue;
            return false;
        }
        return true;
    }

    private static class HostileEntry {
        private final String identifier;

        public HostileEntry(String identifierIn) {
            this.identifier = identifierIn;
        }

        public CompoundNBT deserialize() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("identifier", this.identifier);
            return nbt;
        }

        public static HostileEntry serialize(CompoundNBT nbt) {
            return new HostileEntry(nbt.func_74779_i("identifier"));
        }
    }

    private static class BeeNestEntry {
        private final BlockPos position;
        private BlockPos parentNodePosition;

        public BeeNestEntry(BlockPos positionIn) {
            this.position = positionIn;
        }

        public BeeNestEntry(BlockPos positionIn, BlockPos parentPositionIn) {
            this.position = positionIn;
            this.parentNodePosition = parentPositionIn;
        }

        public boolean isEntryValid(ServerWorld worldIn) {
            return worldIn.func_180495_p(this.position).func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get());
        }

        public boolean isOccupantsExistingDisabled(ServerWorld worldIn) {
            return SculkBeeNestBlock.isNestClosed(worldIn.func_180495_p(this.position));
        }

        public void disableOccupantsExiting(ServerWorld world) {
            SculkBeeNestBlock.setNestClosed(world, world.func_180495_p(this.position), this.position);
        }

        public void enableOccupantsExiting(ServerWorld world) {
            SculkBeeNestBlock.setNestOpen(world, world.func_180495_p(this.position), this.position);
        }

        public void setParentNodeToClosest() {
            if (SculkHorde.gravemind.getGravemindMemory().getNodeEntries() != null && !SculkHorde.gravemind.getGravemindMemory().getNodeEntries().isEmpty()) {
                NodeEntry closestEntry = SculkHorde.gravemind.getGravemindMemory().getNodeEntries().get(0);
                for (NodeEntry entry : SculkHorde.gravemind.getGravemindMemory().getNodeEntries()) {
                    if (!(BlockAlgorithms.getBlockDistance(this.position, entry.position) < BlockAlgorithms.getBlockDistance(this.position, closestEntry.position))) continue;
                    closestEntry = entry;
                }
                this.parentNodePosition = closestEntry.position;
            }
        }

        public CompoundNBT deserialize() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("position", this.position.func_218275_a());
            if (this.parentNodePosition != null) {
                nbt.func_74772_a("parentNodePosition", this.parentNodePosition.func_218275_a());
            }
            return nbt;
        }

        public static BeeNestEntry serialize(CompoundNBT nbt) {
            return new BeeNestEntry(BlockPos.func_218283_e((long)nbt.func_74763_f("position")), BlockPos.func_218283_e((long)nbt.func_74763_f("parentNodePosition")));
        }
    }

    private static class NodeEntry {
        private final BlockPos position;
        private long lastTimeWasActive;

        public NodeEntry(BlockPos positionIn) {
            this.position = positionIn;
            this.lastTimeWasActive = System.nanoTime();
        }

        public boolean isEntryValid(ServerWorld worldIn) {
            return worldIn.func_180495_p(this.position).func_177230_c().func_235332_a_((Block)BlockRegistry.SCULK_NODE_BLOCK.get());
        }

        public CompoundNBT deserialize() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("position", this.position.func_218275_a());
            nbt.func_74772_a("lastTimeWasActive", this.lastTimeWasActive);
            return nbt;
        }

        public static NodeEntry serialize(CompoundNBT nbt) {
            return new NodeEntry(BlockPos.func_218283_e((long)nbt.func_74763_f("position")));
        }
    }

    public class GravemindMemory
    extends WorldSavedData {
        public ServerWorld world;
        public Map<String, HostileEntry> hostileEntries;
        private ArrayList<NodeEntry> nodeEntries;
        private ArrayList<BeeNestEntry> beeNestEntries;
        private int sculkAccumulatedMass;
        private final String sculkAccumulatedMassIdentifier = "sculkAccumulatedMass";

        public GravemindMemory() {
            super("sculkhorde_gravemind_memory");
            this.sculkAccumulatedMass = 0;
            this.sculkAccumulatedMassIdentifier = "sculkAccumulatedMass";
            this.nodeEntries = new ArrayList();
            this.beeNestEntries = new ArrayList();
            this.hostileEntries = new HashMap<String, HostileEntry>();
        }

        public int getSculkAccumulatedMass() {
            this.func_76185_a();
            return this.sculkAccumulatedMass;
        }

        public ArrayList<NodeEntry> getNodeEntries() {
            return this.nodeEntries;
        }

        public NodeEntry getClosestNodeEntry(BlockPos pos) {
            NodeEntry closestNode = null;
            double closestDistance = Double.MAX_VALUE;
            for (NodeEntry node : this.getNodeEntries()) {
                if (!(pos.func_177951_i((Vector3i)node.position) < closestDistance)) continue;
                closestNode = node;
                closestDistance = pos.func_177951_i((Vector3i)node.position);
            }
            return closestNode;
        }

        public boolean isInRangeOfNode(BlockPos pos, int distance) {
            if (this.getNodeEntries().isEmpty()) {
                return false;
            }
            return BlockAlgorithms.getBlockDistance(this.getClosestNodeEntry(pos).position, pos) <= (float)distance;
        }

        public ArrayList<BeeNestEntry> getBeeNestEntries() {
            return this.beeNestEntries;
        }

        public Map<String, HostileEntry> getHostileEntries() {
            return this.hostileEntries;
        }

        public boolean isBeeNestPositionInMemory(BlockPos position) {
            for (BeeNestEntry entry : this.getBeeNestEntries()) {
                if (entry.position != position) continue;
                return true;
            }
            return false;
        }

        public boolean isNodePositionInMemory(BlockPos position) {
            for (NodeEntry entry : this.getNodeEntries()) {
                if (!entry.position.equals((Object)position)) continue;
                return true;
            }
            return false;
        }

        public void addSculkAccumulatedMass(int amount) {
            this.func_76185_a();
            this.sculkAccumulatedMass += amount;
        }

        public void subtractSculkAccumulatedMass(int amount) {
            this.func_76185_a();
            this.sculkAccumulatedMass -= amount;
        }

        public void setSculkAccumulatedMass(int amount) {
            this.func_76185_a();
            this.sculkAccumulatedMass = amount;
        }

        public void addNodeToMemory(BlockPos positionIn) {
            if (!this.isNodePositionInMemory(positionIn) && this.getNodeEntries() != null) {
                this.getNodeEntries().add(new NodeEntry(positionIn));
                this.func_76185_a();
            } else if (SculkHorde.DEBUG_MODE) {
                System.out.println("Attempted to Add TreeNode To Memory but failed.");
            }
        }

        public void addBeeNestToMemory(BlockPos positionIn) {
            if (!this.isBeeNestPositionInMemory(positionIn) && this.getBeeNestEntries() != null) {
                this.getBeeNestEntries().add(new BeeNestEntry(positionIn));
                this.func_76185_a();
            }
        }

        public void addHostileToMemory(LivingEntity entityIn, ServerWorld worldIn) {
            if (entityIn == null || EntityAlgorithms.isSculkLivingEntity.test(entityIn) || entityIn instanceof CreeperEntity) {
                return;
            }
            String identifier = entityIn.func_200600_R().toString();
            if (!identifier.isEmpty()) {
                GravemindMemory memory = (GravemindMemory)worldIn.func_217481_x().func_215752_a(() -> new GravemindMemory(), "sculkhorde_gravemind_memory");
                memory.getHostileEntries().putIfAbsent(identifier, new HostileEntry(identifier));
                memory.func_76185_a();
            }
        }

        public void validateNodeEntries(ServerWorld worldIn) {
            long startTime = System.nanoTime();
            for (int index = 0; index < this.nodeEntries.size(); ++index) {
                if (this.getNodeEntries().get(index).isEntryValid(worldIn)) continue;
                Gravemind.this.getGravemindMemory().getNodeEntries().remove(index);
                --index;
                ((GravemindMemory)worldIn.func_217481_x().func_215752_a(() -> new GravemindMemory(), "sculkhorde_gravemind_memory")).func_76185_a();
            }
            long endTime = System.nanoTime();
            if (SculkHorde.DEBUG_MODE) {
                System.out.println("TreeNode Validation Took " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " milliseconds");
            }
        }

        public void validateBeeNestEntries(ServerWorld worldIn) {
            long startTime = System.nanoTime();
            for (int index = 0; index < this.getBeeNestEntries().size(); ++index) {
                this.getBeeNestEntries().get(index).setParentNodeToClosest();
                if (this.getBeeNestEntries().get(index).isEntryValid(worldIn)) continue;
                this.getBeeNestEntries().remove(index);
                --index;
                ((GravemindMemory)worldIn.func_217481_x().func_215752_a(() -> new GravemindMemory(), "sculkhorde_gravemind_memory")).func_76185_a();
            }
            long endTime = System.nanoTime();
            if (SculkHorde.DEBUG_MODE) {
                System.out.println("Bee Nest Validation Took " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " milliseconds");
            }
        }

        public void func_76184_a(CompoundNBT nbt) {
            CompoundNBT gravemindData = nbt.func_74775_l("gravemindData");
            this.getNodeEntries().clear();
            this.getBeeNestEntries().clear();
            this.getHostileEntries().clear();
            this.sculkAccumulatedMass = nbt.func_74762_e("sculkAccumulatedMass");
            int i = 0;
            while (gravemindData.func_74764_b("node_entry" + i)) {
                this.getNodeEntries().add(NodeEntry.serialize(gravemindData.func_74775_l("node_entry" + i)));
                ++i;
            }
            i = 0;
            while (gravemindData.func_74764_b("bee_nest_entry" + i)) {
                this.getBeeNestEntries().add(BeeNestEntry.serialize(gravemindData.func_74775_l("bee_nest_entry" + i)));
                ++i;
            }
            i = 0;
            while (gravemindData.func_74764_b("hostile_entry" + i)) {
                HostileEntry hostileEntry = HostileEntry.serialize(gravemindData.func_74775_l("hostile_entry" + i));
                this.getHostileEntries().putIfAbsent(hostileEntry.identifier, hostileEntry);
                ++i;
            }
            System.out.print("");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            CompoundNBT gravemindData = new CompoundNBT();
            nbt.func_74768_a("sculkAccumulatedMass", this.sculkAccumulatedMass);
            ListIterator<Object> iterator = this.getNodeEntries().listIterator();
            while (iterator.hasNext()) {
                gravemindData.func_218657_a("node_entry" + iterator.nextIndex(), (INBT)((NodeEntry)iterator.next()).deserialize());
            }
            iterator = this.getBeeNestEntries().listIterator();
            while (iterator.hasNext()) {
                gravemindData.func_218657_a("bee_nest_entry" + iterator.nextIndex(), (INBT)((BeeNestEntry)iterator.next()).deserialize());
            }
            int hostileIndex = 0;
            for (Map.Entry<String, HostileEntry> entry : this.getHostileEntries().entrySet()) {
                gravemindData.func_218657_a("hostile_entry" + hostileIndex, (INBT)entry.getValue().deserialize());
                ++hostileIndex;
            }
            nbt.func_218657_a("gravemindData", (INBT)gravemindData);
            return nbt;
        }
    }

    public static enum evolution_states {
        Undeveloped,
        Immature,
        Mature;

    }
}

