/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.entity_factory;

import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactoryEntry;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityFactory {
    private static ArrayList<EntityFactoryEntry> entries;
    private static Random rng;

    public EntityFactory() {
        entries = new ArrayList();
        rng = new Random();
    }

    public EntityFactoryEntry addEntry(EntityType entity, int cost, StrategicValues value, Gravemind.evolution_states minEvolution) {
        EntityFactoryEntry entry = new EntityFactoryEntry(entity, cost, value, minEvolution);
        entries.add(entry);
        return entry;
    }

    public void requestReinforcementAny(World world, BlockPos spawnPosition, boolean noCost, ReinforcementRequest context) {
        int i;
        boolean DEBUG_THIS = false;
        if (DEBUG_THIS) {
            System.out.println("Reinforcement Request Recieved.");
        }
        if (SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass() <= 0) {
            return;
        }
        SculkHorde.gravemind.processReinforcementRequest(context);
        if (!context.isRequestApproved) {
            return;
        }
        ArrayList<EntityFactoryEntry> possibleReinforcements = new ArrayList<EntityFactoryEntry>();
        for (EntityFactoryEntry entry : entries) {
            if (!entry.isEntryAppropriate(context)) continue;
            possibleReinforcements.add(entry);
        }
        if (possibleReinforcements.size() == 0) {
            return;
        }
        EntityFactoryEntry[] mobsToSpawn = new EntityFactoryEntry[context.positions.length];
        HashMap<EntityType, Integer> mobCount = new HashMap<EntityType, Integer>();
        for (i = 0; i < context.positions.length; ++i) {
            if (context.positions[i] == null) continue;
            EntityFactoryEntry randomEntry = null;
            for (int attemptsToGetEntry = 0; randomEntry == null && attemptsToGetEntry < 10; ++attemptsToGetEntry) {
                int randomEntryIndex = rng.nextInt(possibleReinforcements.size());
                randomEntry = (EntityFactoryEntry)possibleReinforcements.get(randomEntryIndex);
                if (randomEntry.getLimit() <= 0 || randomEntry.getLimit() <= mobCount.getOrDefault(randomEntry.getEntity(), 0)) continue;
                mobsToSpawn[i] = randomEntry;
                mobCount.put(randomEntry.getEntity(), mobCount.getOrDefault(randomEntry.getEntity(), 0) + 1);
            }
        }
        for (i = 0; i < mobsToSpawn.length; ++i) {
            if (mobsToSpawn[i] == null) continue;
            EntityFactoryEntry mob = mobsToSpawn[i];
            context.spawnedEntities[i] = (LivingEntity)mob.getEntity().func_220331_a((ServerWorld)world, null, null, context.positions[i], SpawnReason.SPAWNER, true, true);
            if (noCost) continue;
            SculkHorde.gravemind.getGravemindMemory().subtractSculkAccumulatedMass(mob.getCost());
        }
    }

    public void requestReinforcementSculkMass(World world, BlockPos pos, ReinforcementRequest context) {
        if (SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass() > 0 && entries.size() != 0 && context.budget != 0) {
            context.isRequestViewed = true;
            context.isRequestApproved = true;
            ArrayList<EntityFactoryEntry> lottery = new ArrayList<EntityFactoryEntry>();
            for (EntityFactoryEntry entry : entries) {
                if (!entry.isEntryAppropriate(context)) continue;
                lottery.add(entry);
            }
            if (!lottery.isEmpty()) {
                int randomEntryIndex = rng.nextInt(lottery.size());
                EntityFactoryEntry randomEntry = (EntityFactoryEntry)lottery.get(randomEntryIndex);
                context.remaining_balance = context.budget - randomEntry.getCost();
                randomEntry.getEntity().func_220331_a((ServerWorld)world, null, null, pos, SpawnReason.SPAWNER, true, true);
            }
        }
    }

    public static enum StrategicValues {
        Infector,
        Melee,
        Ranged;

    }
}

