/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.entity_factory;

import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;

public class EntityFactoryEntry {
    private int orderCost = 0;
    private EntityType entity = null;
    private int limit = Integer.MAX_VALUE;
    public EntityFactory.StrategicValues strategicValue = EntityFactory.StrategicValues.Melee;
    public Gravemind.evolution_states minEvolutionRequired = Gravemind.evolution_states.Undeveloped;

    public EntityFactoryEntry(EntityType entity, int orderCost, EntityFactory.StrategicValues value, Gravemind.evolution_states minEvolution) {
        this.entity = entity;
        this.orderCost = orderCost;
        this.strategicValue = value;
        this.minEvolutionRequired = minEvolution;
    }

    public int getCost() {
        return this.orderCost;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Nullable
    public EntityType getEntity() {
        return this.entity;
    }

    public EntityFactory.StrategicValues getCategory() {
        return this.strategicValue;
    }

    public boolean isEntryAppropriate(ReinforcementRequest context) {
        if (context == null) {
            return false;
        }
        if (context.budget != -1 && context.budget < this.orderCost) {
            return false;
        }
        if (!context.approvedMobTypes.contains((Object)this.getCategory()) && !context.approvedMobTypes.isEmpty()) {
            return false;
        }
        if (!SculkHorde.gravemind.isEvolutionStateEqualOrLessThanCurrent(this.minEvolutionRequired)) {
            return false;
        }
        return context.sender != ReinforcementRequest.senderType.SculkMass || this.getEntity() != EntityRegistry.SCULK_SPORE_SPEWER;
    }
}

